/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.shared.util;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tenqube/visual_scraper/shared/util/SecurityKeyManager;", "", "()V", "CIPHER_ALGORITHM", "", "KEY_LENGTH_BIT", "", "KEY_PROVIDER_NAME", "VALIDITY_YEARS", "_isSupported", "", "_isSupported$annotations", "appContext", "Landroid/content/Context;", "isSupported", "()Z", "keyEntry", "Ljava/security/KeyStore$Entry;", "decrypt", "base64EncryptedCipherText", "encrypt", "plainText", "init", "", "applicationContext", "initAndroidL", "alias", "initAndroidM", "app_release"})
public final class SecurityKeyManager {
    private static final int KEY_LENGTH_BIT = 2048;
    private static final int VALIDITY_YEARS = 25;
    private static final String KEY_PROVIDER_NAME = "AndroidKeyStore";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static KeyStore.Entry keyEntry;
    private static boolean _isSupported;
    private static Context appContext;
    public static final SecurityKeyManager INSTANCE;

    private static /* synthetic */ void _isSupported$annotations() {
    }

    public final boolean isSupported() {
        return _isSupported;
    }

    public final void init(@NotNull Context applicationContext) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        if (this.isSupported()) {
            return;
        }
        appContext = applicationContext;
        StringBuilder stringBuilder = new StringBuilder();
        Context context = appContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        }
        String alias = stringBuilder.append(context.getPackageName()).append(".rsakeypairs").toString();
        KeyStore keyStore = KeyStore.getInstance(KEY_PROVIDER_NAME);
        boolean bl = false;
        boolean bl2 = false;
        KeyStore $this$apply = keyStore;
        boolean bl3 = false;
        $this$apply.load(null);
        KeyStore keyStore2 = keyStore;
        boolean result = false;
        result = keyStore2.containsAlias(alias) ? true : (Build.VERSION.SDK_INT > 22 && this.initAndroidM(alias) ? true : this.initAndroidL(alias));
        KeyStore.Entry entry = keyStore2.getEntry(alias, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"keyStore.getEntry(alias, null)");
        keyEntry = entry;
        _isSupported = result;
    }

    private final boolean initAndroidM(String alias) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", KEY_PROVIDER_NAME);
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator $receiver = keyPairGenerator;
            boolean bl3 = false;
            if (Build.VERSION.SDK_INT < 23) {
                return false;
            }
            KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(alias, 3).setAlgorithmParameterSpec((AlgorithmParameterSpec)new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4)).setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setDigests(new String[]{"SHA-512", "SHA-384", "SHA-256"}).setUserAuthenticationRequired(false).build();
            $receiver.initialize((AlgorithmParameterSpec)spec);
            $receiver.generateKeyPair();
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    private final boolean initAndroidL(String alias) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", KEY_PROVIDER_NAME);
            boolean bl = false;
            boolean bl2 = false;
            KeyPairGenerator $receiver = keyPairGenerator;
            boolean bl3 = false;
            Calendar start = Calendar.getInstance(Locale.ENGLISH);
            Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
            boolean bl4 = false;
            boolean bl5 = false;
            Calendar $this$apply = calendar;
            boolean bl6 = false;
            $this$apply.add(1, 25);
            Calendar end = calendar;
            Context context = appContext;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
            }
            KeyPairGeneratorSpec.Builder builder = new KeyPairGeneratorSpec.Builder(context).setKeySize(2048).setAlias(alias).setSubject(new X500Principal("CN=francescojo.github.com, OU=Android dev, O=Francesco Jo, L=Chiyoda, ST=Tokyo, C=JP")).setSerialNumber(BigInteger.ONE);
            Calendar calendar2 = start;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"start");
            KeyPairGeneratorSpec.Builder builder2 = builder.setStartDate(calendar2.getTime());
            Calendar calendar3 = end;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar3, (String)"end");
            KeyPairGeneratorSpec spec = builder2.setEndDate(calendar3.getTime()).build();
            $receiver.initialize((AlgorithmParameterSpec)spec);
            $receiver.generateKeyPair();
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    @NotNull
    public final String encrypt(@NotNull String plainText) {
        Intrinsics.checkParameterIsNotNull((Object)plainText, (String)"plainText");
        if (!_isSupported) {
            return plainText;
        }
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        boolean bl = false;
        boolean bl2 = false;
        Cipher $this$apply = cipher;
        boolean bl3 = false;
        KeyStore.Entry entry = keyEntry;
        if (entry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyEntry");
        }
        if (entry == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
        }
        Certificate certificate = ((KeyStore.PrivateKeyEntry)entry).getCertificate();
        Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"(keyEntry as KeyStore.PrivateKeyEntry).certificate");
        $this$apply.init(1, certificate.getPublicKey());
        Cipher cipher2 = cipher;
        String string = plainText;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        byte[] encryptedBytes = cipher2.doFinal(bytes);
        byte[] base64EncryptedBytes = Base64.encode((byte[])encryptedBytes, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)base64EncryptedBytes, (String)"base64EncryptedBytes");
        byte[] byArray2 = base64EncryptedBytes;
        boolean bl5 = false;
        return new String(byArray2, Charsets.UTF_8);
    }

    @NotNull
    public final String decrypt(@NotNull String base64EncryptedCipherText) {
        Intrinsics.checkParameterIsNotNull((Object)base64EncryptedCipherText, (String)"base64EncryptedCipherText");
        if (!_isSupported) {
            return base64EncryptedCipherText;
        }
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        boolean bl = false;
        boolean bl2 = false;
        Cipher $this$apply = cipher;
        boolean bl3 = false;
        KeyStore.Entry entry = keyEntry;
        if (entry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyEntry");
        }
        if (entry == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.PrivateKeyEntry");
        }
        $this$apply.init(2, ((KeyStore.PrivateKeyEntry)entry).getPrivateKey());
        Cipher cipher2 = cipher;
        String string = base64EncryptedCipherText;
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] base64EncryptedBytes = byArray;
        byte[] encryptedBytes = Base64.decode((byte[])base64EncryptedBytes, (int)0);
        byte[] decryptedBytes = cipher2.doFinal(encryptedBytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)decryptedBytes, (String)"decryptedBytes");
        byte[] byArray2 = decryptedBytes;
        boolean bl5 = false;
        return new String(byArray2, Charsets.UTF_8);
    }

    private SecurityKeyManager() {
    }

    static {
        SecurityKeyManager securityKeyManager;
        INSTANCE = securityKeyManager = new SecurityKeyManager();
    }
}

