package com.tenqube.visual_scraper.webviewhtmlloader

import android.content.SharedPreferences
import com.google.gson.Gson
import com.jakewharton.retrofit2.adapter.kotlin.coroutines.CoroutineCallAdapterFactory
import com.tenqube.visual_scraper.api.ScrapApiService
import com.tenqube.visual_scraper.constants.Constants
import com.tenqube.visual_scraper.utils.NullOnEmptyConverterFactory
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory

object RetrofitInjection {

    fun provideRetrofit(okHttpClient: OkHttpClient, preferences: SharedPreferences): Retrofit {
        return Retrofit.Builder()
                .baseUrl(String.format(ScrapApiService.BASE_URL, preferences.getString(Constants.PREF_KEY.LAYER, "dev")))
                .client(okHttpClient)
                .addConverterFactory(NullOnEmptyConverterFactory())
                .addConverterFactory(GsonConverterFactory.create(Gson()))
                .addCallAdapterFactory(CoroutineCallAdapterFactory())
                .build()
    }
}