package com.tenqube.visual_scraper.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;

import java.util.List;


@Dao
public interface OrderApiRuleDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderApiRuleJson orderApiRuleJson);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insert(List<OrderApiRuleJson> orderApiRuleJson);

    @Query("SELECT * FROM order_api_rule " +
            "WHERE mall_id = :mId")
    OrderApiRuleJson getInfo(int mId);
}
