/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tenqube.visual_scraper.MallViewHandler;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.mall.FactoryMall;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.query.Password;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.thirdparty.commerce.CommerceManager;
import com.tenqube.visual_scraper.thirdparty.market.MarketScrapper;
import com.tenqube.visual_scraper.thirdparty.mart.MartData;
import com.tenqube.visual_scraper.thirdparty.mart.MartScrapper;
import com.tenqube.visual_scraper.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import timber.log.Timber;

public class ScrapManager {
    private static ScrapManager sInstance;
    private final Context context;
    public static final String HANDLER_MSG_ERROR = "error";
    public static final String HANDLER_MSG = "msg";
    public static final String HANDLER_MSG_MALL_ID = "mallId";
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAXIMUM_POOL_SIZE = 4;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private BlockingQueue<Runnable> mParserWorkQueue;
    private ThreadPoolExecutor mParserThreadPool;
    private final ScrapRepository repository;
    private final CommerceManager commerceManager;
    private final Handler handler;
    private ScrapService.OnResultCallback<Integer> callback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrapManager getInstance(Context context, ScrapRepository repository, CommerceManager commerceManager, Handler handler) {
        if (sInstance != null) return sInstance;
        Class<ScrapManager> clazz = ScrapManager.class;
        synchronized (ScrapManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ScrapManager(context, repository, commerceManager, handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setCallback(ScrapService.OnResultCallback<Integer> callback) {
        this.callback = callback;
    }

    private ScrapManager(Context context, ScrapRepository repository, CommerceManager commerceManager, Handler handler) {
        this.context = context;
        this.repository = repository;
        this.commerceManager = commerceManager;
        this.handler = handler;
        this.mParserWorkQueue = new LinkedBlockingQueue<Runnable>();
        this.mParserThreadPool = new ThreadPoolExecutor(2, 4, 10L, KEEP_ALIVE_TIME_UNIT, this.mParserWorkQueue);
    }

    private void showScrapingToast(String mallName) {
        Handler mainHandler = new Handler(this.context.getMainLooper());
        Runnable myRunnable = () -> Toast.makeText((Context)this.context, (CharSequence)(mallName + " \uc1fc\ud551 \ub0b4\uc5ed\uc744 \ubd88\ub7ec\uc624\uace0 \uc788\uc2b5\ub2c8\ub2e4"), (int)0).show();
        mainHandler.post(myRunnable);
    }

    private void showFinishToast(String mallName) {
        Handler mainHandler = new Handler(this.context.getMainLooper());
        Runnable myRunnable = () -> Toast.makeText((Context)this.context, (CharSequence)(mallName + " \uc870\ud68c \uc644\ub8cc"), (int)0).show();
        mainHandler.post(myRunnable);
    }

    private void sendMsg(@Nullable Handler handler, Constants.ScrapState state, Constants.ERROR error, String msg, int mallId) {
        if (this.callback != null) {
            if (state == Constants.ScrapState.SUCCESS) {
                this.callback.onDataLoaded(mallId);
            } else {
                this.callback.onFail(mallId, error, msg);
            }
        }
        Thread.interrupted();
    }

    void startScrap(MallWithUser mallWithUser, MartScrapper martScrapper, boolean isLoginSkip) {
        this.mParserThreadPool.execute(() -> {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                martScrapper.init(msg -> {
                    Timber.i((String)"init : %s", (Object[])new Object[]{msg});
                    if (!TextUtils.isEmpty((CharSequence)msg)) {
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, (String)msg, mallWithUser.mall.getId());
                        return;
                    }
                    if (mallWithUser.mall.getId() != Constants.MALL.Homeplus.getMallId()) {
                        if (isLoginSkip) {
                            this.startParsing(mallWithUser, martScrapper, isLoginSkip);
                        } else {
                            martScrapper.addUser(mallWithUser.mall.getId(), mallWithUser.user.getUserId(), mallWithUser.user.getUserPwd().getValue(), userMsg -> {
                                Timber.i((String)"addUser : %s", (Object[])new Object[]{userMsg});
                                if (!TextUtils.isEmpty((CharSequence)userMsg)) {
                                    this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.LOGIN_FAIL, (String)userMsg, mallWithUser.mall.getId());
                                    return;
                                }
                                mallWithUser.user.setLogin(true);
                                this.repository.insertUsers(mallWithUser.user, uId -> {
                                    if (!isLoginSkip) {
                                        this.showScrapingToast(mallWithUser.mall.getDisplayName());
                                    }
                                    mallWithUser.user.setId((int)uId);
                                    this.startParsing(mallWithUser, martScrapper, isLoginSkip);
                                });
                            });
                        }
                    } else if (isLoginSkip) {
                        this.startParsing(mallWithUser, martScrapper, isLoginSkip);
                    } else {
                        mallWithUser.user.setLogin(true);
                        this.repository.insertUsers(mallWithUser.user, uId -> {
                            mallWithUser.user.setId((int)uId);
                            this.startParsing(mallWithUser, martScrapper, isLoginSkip);
                        });
                    }
                });
            }
            catch (Exception e) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, e.toString(), mallWithUser.mall.getId());
            }
        });
    }

    void startScrap(final MallWithUser mallWithUser, final MarketScrapper marketScrapper, final boolean isLoginSkip, final @Nullable MallViewHandler mallViewService) {
        this.mParserThreadPool.execute(() -> {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                marketScrapper.startWebViewLogin(mallWithUser.user, new MallViewHandler(){

                    @Override
                    public void setWebView(int mallId, WebView webView, int isVisible) {
                        Log.i((String)"Scrap", (String)("setWebView" + isVisible));
                        if (mallViewService != null) {
                            mallViewService.setWebView(mallId, webView, isVisible);
                        }
                    }

                    @Override
                    public void notifyInProgressStatus(String msg) {
                        if (mallViewService != null) {
                            mallViewService.notifyInProgressStatus(msg);
                        }
                    }

                    @Override
                    public void onCaptchaLoginSuccess(int mallId, String id, String pwd) {
                        MallWithUser newUser = new MallWithUser(mallWithUser.mall, new UserEntity(mallId, id, new Password(pwd)));
                        newUser.user.setLogin(true);
                        ScrapManager.this.repository.insertUsers(newUser.user, uId -> mallWithUser2.user.setId((int)uId));
                        ScrapManager.this.startScrap(newUser, marketScrapper, isLoginSkip, mallViewService);
                        if (mallViewService != null) {
                            mallViewService.onCaptchaLoginSuccess(mallId, id, pwd);
                        }
                    }

                    @Override
                    @NonNull
                    public Context getContext() {
                        if (mallViewService != null) {
                            return mallViewService.getContext();
                        }
                        return null;
                    }
                }, new ScrapService.OnResult<List<OrderEntity>>(){

                    @Override
                    public void onSuccess(int mId, List<OrderEntity> items, String msg) {
                        ScrapManager.this.commerceManager.saveOnlineOrders(mId, items);
                        mallWithUser.user.setLogin(true);
                        ScrapManager.this.repository.insertUsers(mallWithUser.user, uId -> {
                            mallWithUser2.user.setId((int)uId);
                            ScrapManager.this.repository.insertOrders(items, insertedList -> {
                                if (!isLoginSkip) {
                                    ScrapManager.this.showScrapingToast(mallWithUser2.mall.getDisplayName());
                                }
                                long lastScrapAt = Utils.getLastScrapAt();
                                ScrapManager.this.repository.updateUserLastScrapAt(lastScrapAt, mallWithUser2.mall.getId(), mallWithUser2.user.getUserId());
                                ScrapManager.this.repository.callInsertOrderList();
                                if (!isLoginSkip) {
                                    ScrapManager.this.showFinishToast(mallWithUser2.mall.getDisplayName());
                                }
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.SUCCESS, Constants.ERROR.NONE, "success", mallWithUser2.mall.getId());
                            });
                        });
                    }

                    @Override
                    public void onFail(int mId, Constants.ERROR error, String msg) {
                        ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.FAIL, error, msg, mId);
                    }

                    @Override
                    public void onCaptcha(int mId, WebView webView) {
                        ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.FAIL, Constants.ERROR.CAPTCHA, "captcha", mId);
                    }
                });
            }
            catch (Exception e) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NONE, e.toString(), mallWithUser.mall.getId());
            }
        });
    }

    private void startParsing(MallWithUser mallWithUser, MartScrapper martScrapper, boolean isLoginSkip) {
        martScrapper.start(mallWithUser.mall.getId(), scrapMsg -> {
            Timber.i((String)"start Scrap : %s", (Object[])new Object[]{scrapMsg});
            if (!TextUtils.isEmpty((CharSequence)scrapMsg)) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.LOGIN_FAIL, (String)scrapMsg, mallWithUser.mall.getId());
                return;
            }
            martScrapper.getMartItems(mallWithUser.mall.getId(), martItems -> {
                if (!isLoginSkip) {
                    this.showScrapingToast(mallWithUser.mall.getDisplayName());
                }
                this.commerceManager.saveOfflineOrders(mallWithUser.mall.getId(), (List<? extends MartData>)martItems);
                ArrayList<OrderEntity> results = new ArrayList<OrderEntity>();
                for (MartData mart : martItems) {
                    results.add(mart.toEntity(mallWithUser.mall.getId(), mallWithUser.user.getId()));
                }
                this.repository.insertOrders(results, insertedList -> {
                    long lastScrapAt = Utils.getLastScrapAt();
                    this.repository.updateUserLastScrapAt(lastScrapAt, mallWithUser.mall.getId(), mallWithUser.user.getUserId());
                    this.repository.callInsertOrderList();
                    if (!isLoginSkip) {
                        this.showFinishToast(mallWithUser.mall.getDisplayName());
                    }
                    this.sendMsg(this.handler, Constants.ScrapState.SUCCESS, Constants.ERROR.NONE, "success", mallWithUser.mall.getId());
                });
            });
        });
    }

    void startScrap(MallWithUser mallWithUser, WebViewManager webViewManager, boolean isLoginSkip) {
        this.mParserThreadPool.execute(() -> {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Timber.i((String)("loginMallWithUser : " + mallWithUser), (Object[])new Object[0]);
                this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
                    Timber.i((String)("loginloginRule : " + loginRule), (Object[])new Object[0]);
                    Mall m = FactoryMall.create(new MallData(mallWithUser.mall.getId(), mallWithUser.mall.getName(), mallWithUser.mall.getDisplayName()), this.repository, webViewManager);
                    Timber.i((String)("loginMall : " + m), (Object[])new Object[0]);
                    if (m == null) {
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.EMPTY_MALL, "empty factory mall", mallWithUser.mall.getId());
                        return;
                    }
                    webViewManager.setMall(m);
                    if (loginRule != null && loginRule.loginWebRule != null) {
                        Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc874\uc7ac, startWebViewLogin", (Object[])new Object[0]);
                        m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, isLoginSkip, new ScrapService.OnResult<List<OrderEntity>>(){

                            @Override
                            public void onSuccess(int mId, List<OrderEntity> items, String msg) {
                                ScrapManager.this.commerceManager.saveOnlineOrders(mId, items);
                                ScrapManager.this.repository.callInsertOrderList();
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.SUCCESS, Constants.ERROR.NONE, "success", mId);
                            }

                            @Override
                            public void onFail(int mId, Constants.ERROR error, String msg) {
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.FAIL, error, msg, mId);
                            }

                            @Override
                            public void onCaptcha(int mId, WebView webView) {
                            }
                        });
                    } else {
                        Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c ", (Object[])new Object[0]);
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NOT_FOUND_LOGIN_RULE, "\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c", mallWithUser.mall.getId());
                    }
                });
            }
            catch (Exception e) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NOT_FOUND_LOGIN_RULE, e.toString(), mallWithUser.mall.getId());
            }
        });
    }

    public void logout(int mId) {
        try {
            WebViewManager webViewManager = new WebViewManager(this.context, null);
            Mall m = FactoryMall.create(new MallData(mId, "", ""), this.repository, webViewManager);
            webViewManager.setMall(m);
            if (m != null) {
                m.logout();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    }
}

