package com.tenqube.visual_scraper.model.view;

import androidx.annotation.NonNull;

import java.io.Serializable;
import java.util.Date;

public class ViewMoreInfo implements Serializable {

    private final int lastOrderId;

    @NonNull
    private final Date bottomOrderDate;

    private final int bottomOrderId;

    public ViewMoreInfo(int lastOrderId, @NonNull Date bottomOrderDate, int bottomOrderId) {
        this.lastOrderId = lastOrderId;
        this.bottomOrderDate = bottomOrderDate;
        this.bottomOrderId = bottomOrderId;
    }

    public int getLastOrderId() {
        return lastOrderId;
    }

    public Date getBottomOrderDate() {
        return bottomOrderDate;
    }

    public int getBottomOrderId() {
        return bottomOrderId;
    }

    @Override
    public String toString() {
        return "ViewMoreInfo{" +
                "lastOrderId=" + lastOrderId +
                ", bottomOrderDate=" + bottomOrderDate +
                ", bottomOrderId=" + bottomOrderId +
                '}';
    }
}
