package com.tenqube.visual_scraper.market.dto.coupang

data class CoupangOrderDto(
        val pageProps: PageProps
) {

    data class PageProps(val domains: Domain)

    data class Domain(val desktopOrder: DesktopOrder)

    data class DesktopOrder(val orderList: List<Order>)

    data class Order(
            val orderId: Long,
            val memberId: String,
            val title: String,
            val orderedAt: Long,
            val deliveryGroupList: List<DeliveryGroupList>

    )

    data class DeliveryGroupList(
            val shipmentBoxId: Long,
            val invoiceNumber: String,
            val tracking: Tracking?,
            val productList: List<Product>
    )

    data class Tracking(val done: Boolean) // 배송 완료 상태

    data class Product(
            val productId: Long,
            val vendorItemId: Long,
            val productName: String,
            val vendorItemName: String,
            val quantity: Int,
            val originalPaymentPrice: Int,
            val unitPrice: Int,
            val imagePath: String
    )

}


