package com.tenqube.visual_scraper.mall;


import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import java.util.Date;

public class ElevenStreet extends Mall {
    private final String PRODUCT_URL = "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s&xfrom=&xzone=";

    public ElevenStreet(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    public String getBaseUrl() {
        return "https://www.11st.co.kr/main";
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderNum(), 0, null);
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
////        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink(), 0, "href");
//
//        return order;
//    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        //2018-04-19 (201804197627389)
        try {
            if (!TextUtils.isEmpty(orderDate)) {
                String date = orderDate.substring(0, orderDate.indexOf("(") -1);
                return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty(orderNum) && orderNum.length() > 1) {
                String filteredOrderNum = orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")"));
                return filteredOrderNum;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

//    @Override
//    protected String detailProductLinkFilter(@NonNull String detailProductLink) {
//        if (!TextUtils.isEmpty(detailProductLink)) {
//            String[] temps = detailProductLink.split(",");
//            if (temps.length > 3) {
//                String prodNo = temps[3].replace("'","").trim();
//                return String.format(PRODUCT_URL, prodNo);
//            }
//        }
//        return "";
//    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        //36,400원 (1개)
        int result = 1;
        try {

            if (!TextUtils.isEmpty(quantity)) {
                result = Integer.parseInt(quantity.substring(quantity.indexOf("(") + 1, quantity.indexOf(")")).replace("개","").trim());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replaceAll("원","").replaceAll(",",""));
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        int index = imgUrl.indexOf("/pd/");
        return index != -1 ? "http://image.11st.co.kr"+imgUrl.substring(index) : imgUrl;
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        /**
         * success
         * https://login.11st.co.kr/login/PwdCampaign.tmall?popup=N&protocol=https&targetUrl=
          */

        /**
         * fail
         * https://login.11st.co.kr/auth/front/login.tmall
         */

        if (url.contains("/login/PwdCampaign.tmall")) {
            // 로그인 성공 페이지
            return false;
        } else if (url.contains("login.tmall") ) {
            // 로그인 페이지
            return true;
        }
        return url.contains("login");
    }

    @Override
    public String getLogoutUrl() {
        return "javascript:document.querySelector(\"a[data-log-actionid-label='logout']\").click()";
    }
}
