/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tenqube.visual_scraper.db.converter.AESConverter;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.model.query.Password;
import java.util.ArrayList;
import java.util.List;

public final class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;
    private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserLastScrapAt;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUserIsLogin;
    private final SharedSQLiteStatement __preparedStmtOfDeleteUsersByMallId;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `users` (`u_id`,`mall_id`,`user_id`,`pwd`,`cookie`,`is_login`,`is_progress`,`last_scrap_at`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                String _tmp = AESConverter.encrypt(value.getUserPwd());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                if (value.getCookie() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCookie());
                }
                int _tmp_1 = value.isLogin() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                int _tmp_2 = value.isProgress() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                stmt.bindLong(8, value.getLastScrapAt());
            }
        };
        this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `users` SET `u_id` = ?,`mall_id` = ?,`user_id` = ?,`pwd` = ?,`cookie` = ?,`is_login` = ?,`is_progress` = ?,`last_scrap_at` = ? WHERE `u_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                String _tmp = AESConverter.encrypt(value.getUserPwd());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                if (value.getCookie() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCookie());
                }
                int _tmp_1 = value.isLogin() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                int _tmp_2 = value.isProgress() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                stmt.bindLong(8, value.getLastScrapAt());
                stmt.bindLong(9, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM users";
                return "DELETE FROM users";
            }
        };
        this.__preparedStmtOfUpdateUserLastScrapAt = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE users SET last_scrap_at = ? WHERE mall_id = ? AND user_id = ?";
                return "UPDATE users SET last_scrap_at = ? WHERE mall_id = ? AND user_id = ?";
            }
        };
        this.__preparedStmtOfUpdateUserIsLogin = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE users SET is_login = ? WHERE mall_id = ?";
                return "UPDATE users SET is_login = ? WHERE mall_id = ?";
            }
        };
        this.__preparedStmtOfDeleteUsersByMallId = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE  FROM users WHERE mall_id = ?";
                return "DELETE  FROM users WHERE mall_id = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long insert(UserEntity user) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfUserEntity.insertAndReturnId((Object)user);
            this.__db.setTransactionSuccessful();
            Long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(UserEntity user) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUserEntity.handle((Object)user);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserLastScrapAt(long lastScrapAt, int mallId, String userId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserLastScrapAt.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, lastScrapAt);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, (long)mallId);
        _argIndex = 3;
        if (userId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, userId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserLastScrapAt.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserIsLogin(int mallId, boolean isLogin) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUserIsLogin.acquire();
        int _argIndex = 1;
        int _tmp = isLogin ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, (long)mallId);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUserIsLogin.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUsersByMallId(int mallId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteUsersByMallId.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)mallId);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteUsersByMallId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserEntity> getUsers() {
        String _sql = "SELECT * FROM users ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users ", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"u_id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfUserPwd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pwd");
            int _cursorIndexOfCookie = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cookie");
            int _cursorIndexOfIsLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_login");
            int _cursorIndexOfIsProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_progress");
            int _cursorIndexOfLastScrapAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_scrap_at");
            ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmp = _cursor.getString(_cursorIndexOfUserPwd);
                Password _tmpUserPwd = AESConverter.decrypt(_tmp);
                UserEntity _item = new UserEntity(_tmpMallId, _tmpUserId, _tmpUserPwd);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpCookie = _cursor.getString(_cursorIndexOfCookie);
                _item.setCookie(_tmpCookie);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsLogin);
                boolean _tmpIsLogin = _tmp_1 != 0;
                _item.setLogin(_tmpIsLogin);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsProgress);
                boolean _tmpIsProgress = _tmp_2 != 0;
                _item.setProgress(_tmpIsProgress);
                long _tmpLastScrapAt = _cursor.getLong(_cursorIndexOfLastScrapAt);
                _item.setLastScrapAt(_tmpLastScrapAt);
                _result.add(_item);
            }
            ArrayList<UserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserEntity getUser(int uId) {
        String _sql = "SELECT * FROM users where u_id = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users where u_id = ? ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)uId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            UserEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"u_id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfUserPwd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pwd");
            int _cursorIndexOfCookie = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cookie");
            int _cursorIndexOfIsLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_login");
            int _cursorIndexOfIsProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_progress");
            int _cursorIndexOfLastScrapAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_scrap_at");
            if (_cursor.moveToFirst()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmp = _cursor.getString(_cursorIndexOfUserPwd);
                Password _tmpUserPwd = AESConverter.decrypt(_tmp);
                _result = new UserEntity(_tmpMallId, _tmpUserId, _tmpUserPwd);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpCookie = _cursor.getString(_cursorIndexOfCookie);
                _result.setCookie(_tmpCookie);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsLogin);
                boolean _tmpIsLogin = _tmp_1 != 0;
                _result.setLogin(_tmpIsLogin);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsProgress);
                boolean _tmpIsProgress = _tmp_2 != 0;
                _result.setProgress(_tmpIsProgress);
                long _tmpLastScrapAt = _cursor.getLong(_cursorIndexOfLastScrapAt);
                _result.setLastScrapAt(_tmpLastScrapAt);
            } else {
                _result = null;
            }
            UserEntity userEntity = _result;
            return userEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserEntity getUserByNameAndMal(String name, int mId) {
        String _sql = "SELECT * FROM users where user_id = ? AND mall_id = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users where user_id = ? AND mall_id = ? ", (int)2);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)mId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            UserEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"u_id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfUserPwd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pwd");
            int _cursorIndexOfCookie = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cookie");
            int _cursorIndexOfIsLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_login");
            int _cursorIndexOfIsProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_progress");
            int _cursorIndexOfLastScrapAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_scrap_at");
            if (_cursor.moveToFirst()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmp = _cursor.getString(_cursorIndexOfUserPwd);
                Password _tmpUserPwd = AESConverter.decrypt(_tmp);
                _result = new UserEntity(_tmpMallId, _tmpUserId, _tmpUserPwd);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpCookie = _cursor.getString(_cursorIndexOfCookie);
                _result.setCookie(_tmpCookie);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsLogin);
                boolean _tmpIsLogin = _tmp_1 != 0;
                _result.setLogin(_tmpIsLogin);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsProgress);
                boolean _tmpIsProgress = _tmp_2 != 0;
                _result.setProgress(_tmpIsProgress);
                long _tmpLastScrapAt = _cursor.getLong(_cursorIndexOfLastScrapAt);
                _result.setLastScrapAt(_tmpLastScrapAt);
            } else {
                _result = null;
            }
            UserEntity userEntity = _result;
            return userEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserEntity> findUsersByLoginState(int login2) {
        String _sql = "SELECT * FROM users WHERE is_login = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM users WHERE is_login = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)login2);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"u_id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"user_id");
            int _cursorIndexOfUserPwd = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pwd");
            int _cursorIndexOfCookie = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cookie");
            int _cursorIndexOfIsLogin = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_login");
            int _cursorIndexOfIsProgress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_progress");
            int _cursorIndexOfLastScrapAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_scrap_at");
            ArrayList<UserEntity> _result = new ArrayList<UserEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmp = _cursor.getString(_cursorIndexOfUserPwd);
                Password _tmpUserPwd = AESConverter.decrypt(_tmp);
                UserEntity _item = new UserEntity(_tmpMallId, _tmpUserId, _tmpUserPwd);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpCookie = _cursor.getString(_cursorIndexOfCookie);
                _item.setCookie(_tmpCookie);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsLogin);
                boolean _tmpIsLogin = _tmp_1 != 0;
                _item.setLogin(_tmpIsLogin);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsProgress);
                boolean _tmpIsProgress = _tmp_2 != 0;
                _item.setProgress(_tmpIsProgress);
                long _tmpLastScrapAt = _cursor.getLong(_cursorIndexOfLastScrapAt);
                _item.setLastScrapAt(_tmpLastScrapAt);
                _result.add(_item);
            }
            ArrayList<UserEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

