/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tenqube.visual_scraper.db.converter.OrderRuleConverter;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import java.util.List;

public final class OrderWebRuleDao_Impl
implements OrderWebRuleDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OrderWebRule> __insertionAdapterOfOrderWebRule;

    public OrderWebRuleDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrderWebRule = new EntityInsertionAdapter<OrderWebRule>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `order_web_rule` (`_id`,`mall_id`,`url`,`request_body`,`request_method`,`period_scripts`,`container`,`title`,`order_date`,`order_hms`,`order_option`,`quantity`,`price`,`order_num`,`order_state`,`img_url`,`detail_order_link`,`detail_product_link`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrderWebRule value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                String _tmp = QueryRuleConverter.fromOrderRules(value.getUrl());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getRequestBody() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRequestBody());
                }
                stmt.bindLong(5, (long)value.getRequestMethod());
                String _tmp_1 = QueryRuleConverter.fromOrderRules(value.getPeriodScripts());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                String _tmp_2 = OrderRuleConverter.fromOrderRules(value.getContainer());
                if (_tmp_2 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_2);
                }
                String _tmp_3 = OrderRuleConverter.fromOrderRules(value.getTitle());
                if (_tmp_3 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_3);
                }
                String _tmp_4 = OrderRuleConverter.fromOrderRules(value.getOrderDate());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
                String _tmp_5 = OrderRuleConverter.fromOrderRules(value.getOrderHms());
                if (_tmp_5 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_5);
                }
                String _tmp_6 = OrderRuleConverter.fromOrderRules(value.getOrderOption());
                if (_tmp_6 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_6);
                }
                String _tmp_7 = OrderRuleConverter.fromOrderRules(value.getQuantity());
                if (_tmp_7 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_7);
                }
                String _tmp_8 = OrderRuleConverter.fromOrderRules(value.getPrice());
                if (_tmp_8 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_8);
                }
                String _tmp_9 = OrderRuleConverter.fromOrderRules(value.getOrderNum());
                if (_tmp_9 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_9);
                }
                String _tmp_10 = OrderRuleConverter.fromOrderRules(value.getOrderState());
                if (_tmp_10 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_10);
                }
                String _tmp_11 = OrderRuleConverter.fromOrderRules(value.getImgUrl());
                if (_tmp_11 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_11);
                }
                String _tmp_12 = OrderRuleConverter.fromOrderRules(value.getDetailOrderLink());
                if (_tmp_12 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_12);
                }
                String _tmp_13 = OrderRuleConverter.fromOrderRules(value.getDetailProductLink());
                if (_tmp_13 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_13);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(OrderWebRule orderWebRuleJson) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfOrderWebRule.insertAndReturnId((Object)orderWebRuleJson);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insertList(List<OrderWebRule> orderWebRuleJsons) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfOrderWebRule.insertAndReturnIdsList(orderWebRuleJsons);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderWebRule getInfo(int mId) {
        String _sql = "SELECT * FROM order_web_rule WHERE mall_id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM order_web_rule WHERE mall_id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)mId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            OrderWebRule _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request_body");
            int _cursorIndexOfRequestMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request_method");
            int _cursorIndexOfPeriodScripts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_scripts");
            int _cursorIndexOfContainer = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"container");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfOrderDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_date");
            int _cursorIndexOfOrderHms = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_hms");
            int _cursorIndexOfOrderOption = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_option");
            int _cursorIndexOfQuantity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"quantity");
            int _cursorIndexOfPrice = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"price");
            int _cursorIndexOfOrderNum = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_num");
            int _cursorIndexOfOrderState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order_state");
            int _cursorIndexOfImgUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"img_url");
            int _cursorIndexOfDetailOrderLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_order_link");
            int _cursorIndexOfDetailProductLink = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"detail_product_link");
            if (_cursor.moveToFirst()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmp = _cursor.getString(_cursorIndexOfUrl);
                QueryRuleBody _tmpUrl = QueryRuleConverter.toParsingOrderRule(_tmp);
                String _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
                int _tmpRequestMethod = _cursor.getInt(_cursorIndexOfRequestMethod);
                String _tmp_1 = _cursor.getString(_cursorIndexOfPeriodScripts);
                QueryRuleBody _tmpPeriodScripts = QueryRuleConverter.toParsingOrderRule(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfContainer);
                ParsingOrderRules _tmpContainer = OrderRuleConverter.toParsingOrderRule(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfTitle);
                ParsingOrderRules _tmpTitle = OrderRuleConverter.toParsingOrderRule(_tmp_3);
                String _tmp_4 = _cursor.getString(_cursorIndexOfOrderDate);
                ParsingOrderRules _tmpOrderDate = OrderRuleConverter.toParsingOrderRule(_tmp_4);
                String _tmp_5 = _cursor.getString(_cursorIndexOfOrderHms);
                ParsingOrderRules _tmpOrderHms = OrderRuleConverter.toParsingOrderRule(_tmp_5);
                String _tmp_6 = _cursor.getString(_cursorIndexOfOrderOption);
                ParsingOrderRules _tmpOrderOption = OrderRuleConverter.toParsingOrderRule(_tmp_6);
                String _tmp_7 = _cursor.getString(_cursorIndexOfQuantity);
                ParsingOrderRules _tmpQuantity = OrderRuleConverter.toParsingOrderRule(_tmp_7);
                String _tmp_8 = _cursor.getString(_cursorIndexOfPrice);
                ParsingOrderRules _tmpPrice = OrderRuleConverter.toParsingOrderRule(_tmp_8);
                String _tmp_9 = _cursor.getString(_cursorIndexOfOrderNum);
                ParsingOrderRules _tmpOrderNum = OrderRuleConverter.toParsingOrderRule(_tmp_9);
                String _tmp_10 = _cursor.getString(_cursorIndexOfOrderState);
                ParsingOrderRules _tmpOrderState = OrderRuleConverter.toParsingOrderRule(_tmp_10);
                String _tmp_11 = _cursor.getString(_cursorIndexOfImgUrl);
                ParsingOrderRules _tmpImgUrl = OrderRuleConverter.toParsingOrderRule(_tmp_11);
                String _tmp_12 = _cursor.getString(_cursorIndexOfDetailOrderLink);
                ParsingOrderRules _tmpDetailOrderLink = OrderRuleConverter.toParsingOrderRule(_tmp_12);
                String _tmp_13 = _cursor.getString(_cursorIndexOfDetailProductLink);
                ParsingOrderRules _tmpDetailProductLink = OrderRuleConverter.toParsingOrderRule(_tmp_13);
                _result = new OrderWebRule(_tmpMallId, _tmpUrl, _tmpRequestBody, _tmpRequestMethod, _tmpPeriodScripts, _tmpContainer, _tmpTitle, _tmpOrderDate, _tmpOrderHms, _tmpOrderOption, _tmpQuantity, _tmpPrice, _tmpOrderNum, _tmpOrderState, _tmpImgUrl, _tmpDetailOrderLink, _tmpDetailProductLink);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            OrderWebRule orderWebRule = _result;
            return orderWebRule;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

