/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import java.util.List;

public final class OrderDetailWebRuleDao_Impl
implements OrderDetailWebRuleDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<OrderDetailWebRuleJson> __insertionAdapterOfOrderDetailWebRuleJson;

    public OrderDetailWebRuleDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfOrderDetailWebRuleJson = new EntityInsertionAdapter<OrderDetailWebRuleJson>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `order_detail_web_rule` (`_id`,`mall_id`,`url`,`request_body`,`scripts`) VALUES (nullif(?, 0),?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, OrderDetailWebRuleJson value) {
                stmt.bindLong(1, (long)value.getId());
                stmt.bindLong(2, (long)value.getMallId());
                String _tmp = QueryRuleConverter.fromOrderRules(value.getUrl());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = QueryRuleConverter.fromOrderRules(value.getRequestBody());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                String _tmp_2 = QueryRuleConverter.fromOrderRules(value.getScripts());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(OrderDetailWebRuleJson orderDetailWebRule) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfOrderDetailWebRuleJson.insertAndReturnId((Object)orderDetailWebRule);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insertList(List<OrderDetailWebRuleJson> orderDetailWebRules) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfOrderDetailWebRuleJson.insertAndReturnIdsList(orderDetailWebRules);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderDetailWebRuleJson getInfo(int mId) {
        String _sql = "SELECT * FROM order_detail_web_rule WHERE mall_id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM order_detail_web_rule WHERE mall_id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)mId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            OrderDetailWebRuleJson _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfMallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mall_id");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request_body");
            int _cursorIndexOfScripts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scripts");
            if (_cursor.moveToFirst()) {
                int _tmpMallId = _cursor.getInt(_cursorIndexOfMallId);
                String _tmp = _cursor.getString(_cursorIndexOfUrl);
                QueryRuleBody _tmpUrl = QueryRuleConverter.toParsingOrderRule(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfRequestBody);
                QueryRuleBody _tmpRequestBody = QueryRuleConverter.toParsingOrderRule(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfScripts);
                QueryRuleBody _tmpScripts = QueryRuleConverter.toParsingOrderRule(_tmp_2);
                _result = new OrderDetailWebRuleJson(_tmpMallId, _tmpUrl, _tmpRequestBody, _tmpScripts);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            OrderDetailWebRuleJson orderDetailWebRuleJson = _result;
            return orderDetailWebRuleJson;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

