package com.tenqube.visual_scraper.db.entity;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.tenqube.visual_scraper.db.converter.OrderRuleConverter;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;

import java.io.Serializable;

@Entity(tableName = "order_web_rule",
        indices = {@Index(value = {"mall_id"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id")})
@TypeConverters({OrderRuleConverter.class, QueryRuleConverter.class})
public class OrderWebRule implements Serializable {


    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final int mallId;

    @ColumnInfo(name = "url")
    private final QueryRuleBody url;

    @ColumnInfo(name = "request_body")
    private final String requestBody;

    @ColumnInfo(name = "request_method")
    private final int requestMethod;

    @Nullable
    @ColumnInfo(name = "period_scripts")
    private final QueryRuleBody periodScripts;

//    @ColumnInfo(name = "page_div")
//    private final String pageDiv;

    @ColumnInfo(name = "container")
    private final ParsingOrderRules container;

    @ColumnInfo(name = "title")
    private final ParsingOrderRules title;

    @ColumnInfo(name = "order_date")
    private final ParsingOrderRules orderDate;

    @ColumnInfo(name = "order_hms")
    private final ParsingOrderRules orderHms;

    @ColumnInfo(name = "order_option")
    private final ParsingOrderRules orderOption;

    @ColumnInfo(name = "quantity")
    private final ParsingOrderRules quantity;

    @ColumnInfo(name = "price")
    private final ParsingOrderRules price;

    @ColumnInfo(name = "order_num")
    private final ParsingOrderRules orderNum;

    @ColumnInfo(name = "order_state")
    private final ParsingOrderRules orderState;

    @ColumnInfo(name = "img_url")
    private final ParsingOrderRules imgUrl;

    @ColumnInfo(name = "detail_order_link")
    private final ParsingOrderRules detailOrderLink;

    @ColumnInfo(name = "detail_product_link")
    private final ParsingOrderRules detailProductLink;

    public OrderWebRule(int mallId,
                        QueryRuleBody url,
                        String requestBody,
                        int requestMethod,
                        QueryRuleBody periodScripts,
                        ParsingOrderRules container,
                        ParsingOrderRules title,
                        ParsingOrderRules orderDate,
                        ParsingOrderRules orderHms,
                        ParsingOrderRules orderOption,
                        ParsingOrderRules quantity,
                        ParsingOrderRules price,
                        ParsingOrderRules orderNum,
                        ParsingOrderRules orderState,
                        ParsingOrderRules imgUrl,
                        ParsingOrderRules detailOrderLink,
                        ParsingOrderRules detailProductLink) {
        this.mallId = mallId;
        this.url = url;
        this.requestBody = requestBody;
        this.requestMethod = requestMethod;
        this.periodScripts = periodScripts;
        this.container = container;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
        this.detailOrderLink = detailOrderLink;
        this.detailProductLink = detailProductLink;
    }

    public int getMallId() {
        return mallId;
    }

    public int getId() {
        return id;
    }

    public QueryRuleBody getUrl() {
        return url;
    }

    @NonNull
    public ParsingOrderRules getContainer() {
        return container;
    }

    @NonNull
    public ParsingOrderRules getTitle() {
        return title;
    }

    @NonNull
    public ParsingOrderRules getOrderDate() {
        return orderDate;
    }

    @NonNull
    public ParsingOrderRules getOrderHms() {
        return orderHms;
    }

    @NonNull
    public ParsingOrderRules getOrderOption() {
        return orderOption;
    }

    @NonNull
    public ParsingOrderRules getQuantity() {
        return quantity;
    }

    @NonNull
    public ParsingOrderRules getPrice() {
        return price;
    }

    @NonNull
    public ParsingOrderRules getOrderNum() {
        return orderNum;
    }

    @NonNull
    public ParsingOrderRules getOrderState() {
        return orderState;
    }

    @NonNull
    public ParsingOrderRules getImgUrl() {
        return imgUrl;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    public QueryRuleBody getPeriodScripts() {
        return periodScripts;
    }

    public ParsingOrderRules getDetailOrderLink() {
        return detailOrderLink;
    }

    public ParsingOrderRules getDetailProductLink() {
        return detailProductLink;
    }

    @Override
    public String toString() {
        return "OrderWebRuleJson{" +
                "id=" + id +
                ", mallId=" + mallId +
                ", url='" + url + '\'' +
                ", requestBody='" + requestBody + '\'' +
                ", requestMethod=" + requestMethod +
                ", periodScripts='" + periodScripts + '\'' +
                ", container='" + container + '\'' +
                ", title='" + title + '\'' +
                ", orderDate='" + orderDate + '\'' +
                ", orderHms='" + orderHms + '\'' +
                ", orderOption='" + orderOption + '\'' +
                ", quantity='" + quantity + '\'' +
                ", price='" + price + '\'' +
                ", orderNum='" + orderNum + '\'' +
                ", orderState='" + orderState + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", detailOrderLink='" + detailOrderLink + '\'' +
                ", detailProductLink='" + detailProductLink + '\'' +
                '}';
    }
}
