package com.tenqube.visual_scraper.db.entity;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import androidx.annotation.Nullable;

import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;

import java.io.Serializable;

@Entity(tableName = "order_detail_web_rule",
        indices = {@Index(value = {"mall_id"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id")})
@TypeConverters({QueryRuleConverter.class})
public class OrderDetailWebRuleJson implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private int id;

    @ColumnInfo(name = "mall_id")
    private final int mallId;

    @ColumnInfo(name = "url")
    private final QueryRuleBody url;

    @Nullable
    @ColumnInfo(name = "request_body")
    private final QueryRuleBody requestBody;

    @Nullable
    @ColumnInfo(name = "scripts")
    private final QueryRuleBody scripts;


    public OrderDetailWebRuleJson(int mallId, QueryRuleBody url, @Nullable QueryRuleBody requestBody, @Nullable QueryRuleBody scripts) {
        this.mallId = mallId;
        this.url = url;
        this.requestBody = requestBody;
        this.scripts = scripts;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMallId() {
        return mallId;
    }

    public QueryRuleBody getUrl() {
        return url;
    }

    @Nullable
    public QueryRuleBody getScripts() {
        return scripts;
    }

    @Nullable
    public QueryRuleBody getRequestBody() {
        return requestBody;
    }


}
