package com.tenqube.visual_scraper.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.tenqube.visual_scraper.db.entity.MallEntity;

import java.util.List;

@Dao
public interface MallDao {

    @Query("SELECT * " +
            "FROM malls " +
            "WHERE m_id = :mId " +
            "AND is_active = 1")
    MallEntity getMall(int mId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertList(List<MallEntity> mallEntity);

    @Query( "SELECT * " +
            "FROM malls " +
            "WHERE is_active = 1")
    List<MallEntity> getMalls();

    @Query( "SELECT * " +
            "FROM malls " +
            "WHERE m_id in (:ids)")
    List<MallEntity> findMallByIds(List<Integer> ids);

}
