/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.thirdparty.commerce;

import android.content.Context;
import com.tenqube.commerce.domain.entity.OrderItem;
import com.tenqube.commerce.domain.entity.Product;
import com.tenqube.commerce.domain.scraping.online.library.domain.market.util.Utils;
import com.tenqube.commerce.domain.usecase.offline.OfflineDto;
import com.tenqube.commerce.domain.usecase.online.OnlineDto;
import com.tenqube.commerce.domain.utils.StringExtKt;
import com.tenqube.commerce.domain.vo.Branch;
import com.tenqube.commerce.domain.vo.CommerceId;
import com.tenqube.commerce.domain.vo.Gender;
import com.tenqube.commerce.domain.vo.Image;
import com.tenqube.commerce.domain.vo.Price;
import com.tenqube.commerce.presentation.ScrapBuilder;
import com.tenqube.commerce.presentation.ScrapService;
import com.tenqube.commerce.presentation.model.Response;
import com.tenqube.commerce.utils.Callback;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.thirdparty.mart.MartData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\u001e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/tenqube/visual_scraper/thirdparty/commerce/CommerceManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "scrapService", "Lcom/tenqube/commerce/presentation/ScrapService;", "getScrapService", "()Lcom/tenqube/commerce/presentation/ScrapService;", "saveOfflineOrders", "", "mId", "", "items", "", "Lcom/tenqube/visual_scraper/thirdparty/mart/MartData;", "saveOnlineOrders", "Lcom/tenqube/visual_scraper/db/entity/OrderEntity;", "signUp", "clientId", "", "birth", "gender", "app_release"})
public final class CommerceManager {
    @NotNull
    private final ScrapService scrapService;
    @NotNull
    private final Context context;

    @NotNull
    public final ScrapService getScrapService() {
        return this.scrapService;
    }

    public final void signUp(@NotNull String clientId, int birth, int gender) {
        Gender gender2;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        switch (gender) {
            case 1: {
                gender2 = Gender.Male;
                break;
            }
            case 0: {
                gender2 = Gender.Female;
                break;
            }
            default: {
                gender2 = Gender.None;
            }
        }
        this.scrapService.signUp(clientId, birth, gender2, (Callback)new Callback<Response<Unit>>(){

            public void onDataLoaded(@NotNull Response<Unit> value) {
                Intrinsics.checkParameterIsNotNull(value, (String)"value");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void saveOfflineOrders(int mId, @NotNull List<? extends MartData> items) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        CommerceId commerceId = CommerceId.Companion.fromOnlineId(mId);
        if (commerceId == null) {
            return;
        }
        CommerceId commerceId2 = commerceId;
        Iterable $this$mapNotNull$iv = items;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence;
            CharSequence charSequence2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MartData it = (MartData)element$iv$iv;
            boolean bl2 = false;
            try {
                String string;
                String string2;
                String string3;
                Branch branch;
                String string4;
                String string5;
                String string6 = it.receiptKey;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.receiptKey");
                String string7 = StringExtKt.toMD5((String)string6);
                Intrinsics.checkExpressionValueIsNotNull((Object)it.receiptKey, (String)"it.receiptKey");
                Double d = it.orderAmount;
                Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"it.orderAmount");
                Price price = new Price(d.doubleValue(), "KRW");
                String string8 = it.branchName;
                if (string8 == null) {
                    string8 = "";
                }
                if ((string5 = it.branchAddress) == null) {
                    string5 = "";
                }
                Branch branch2 = new Branch(string8, string5);
                String string9 = it.receiptProductKey;
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.receiptProductKey");
                charSequence2 = it.barcode;
                String string10 = StringExtKt.toMD5((String)string9);
                Branch branch3 = branch2;
                Price price2 = price;
                CommerceId commerceId3 = commerceId2;
                String string11 = string7;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = charSequence2 == null || charSequence2.length() == 0;
                String string12 = StringExtKt.toMD5((String)(bl5 ? it.name + ";" + commerceId2.getId() : it.barcode + ";" + commerceId2.getId()));
                Intrinsics.checkExpressionValueIsNotNull((Object)it.name, (String)"it.name");
                Double d2 = it.price;
                Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"it.price");
                Price price3 = new Price(d2.doubleValue(), "KRW");
                String string13 = it.barcode;
                if (string13 == null) {
                    string13 = "";
                }
                String string14 = string13;
                Price price4 = price3;
                String string15 = string12;
                Product.Offline offline = new Product.Offline(string15, string4, price4, string14);
                int n = it.buyCount;
                Double d3 = it.price;
                Intrinsics.checkExpressionValueIsNotNull((Object)d3, (String)"it.price");
                String string16 = "\uad6c\ub9e4\uc644\ub8cc";
                Price price5 = new Price(d3.doubleValue(), "KRW");
                int n2 = n;
                Product.Offline offline2 = offline;
                String string17 = string10;
                List list = CollectionsKt.listOf((Object)new OrderItem(string17, (Object)offline2, n2, price5, string16));
                String string18 = it.buyDate;
                Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"it.buyDate");
                long l = Utils.INSTANCE.convertDateTimeStrToCalendar(string18).getTimeInMillis();
                long l2 = System.currentTimeMillis();
                Intrinsics.checkExpressionValueIsNotNull((Object)it.raw, (String)"it.raw");
                Intrinsics.checkExpressionValueIsNotNull((Object)it.posNo, (String)"it.posNo");
                boolean bl6 = false;
                long l3 = l2;
                long l4 = l;
                List list2 = list;
                Branch branch4 = branch = branch3;
                String string19 = string3;
                String string20 = string2;
                boolean bl7 = bl6;
                long l5 = l3;
                long l6 = l4;
                List list3 = list2;
                Price price6 = price2;
                CommerceId commerceId4 = commerceId3;
                String string21 = string;
                String string22 = string11;
                charSequence2 = new OfflineDto(string22, string21, commerceId4, price6, list3, l6, l5, bl7, string20, string19, branch4);
            }
            catch (Exception e) {
                charSequence2 = null;
            }
            if (charSequence2 == null) continue;
            boolean bl8 = false;
            boolean bl9 = false;
            CharSequence it$iv$iv = charSequence;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List offlineItems = (List)destination$iv$iv;
        this.scrapService.saveOfflineOrders(offlineItems);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveOnlineOrders(int mId, @NotNull List<OrderEntity> items) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        CommerceId commerceId = CommerceId.Companion.fromOnlineId(mId);
        if (commerceId == null) {
            return;
        }
        CommerceId commerceId2 = commerceId;
        Iterable $this$mapNotNull$iv = items;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OnlineDto onlineDto;
            OnlineDto onlineDto2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            OrderEntity it = (OrderEntity)element$iv$iv;
            boolean bl2 = false;
            try {
                String string;
                String string2 = it.orderNum;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.orderNum");
                String orderId = StringExtKt.toMD5((String)string2);
                CharSequence charSequence = it.detailProductLink;
                boolean bl3 = false;
                boolean bl4 = false;
                String string3 = charSequence == null || charSequence.length() == 0 ? it.title + ";" + commerceId2.getId() : it.detailProductLink;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(if(it.detailProductLink\u2026{ it.detailProductLink })");
                String productId = StringExtKt.toMD5((String)string3);
                String orderItemId = StringExtKt.toMD5((String)(orderId + productId));
                String string4 = it.orderNum;
                if (string4 == null) {
                    string4 = "";
                }
                double d = it.price;
                String string5 = it.currency;
                if (string5 == null) {
                    string5 = "";
                }
                Price price = new Price(d, string5);
                String string6 = it.title;
                if (string6 == null) {
                    string6 = "";
                }
                double d2 = it.price;
                String string7 = it.currency;
                if (string7 == null) {
                    string7 = "";
                }
                Price price2 = new Price(d2, string7);
                String string8 = it.orderOption;
                if (string8 == null) {
                    string8 = "";
                }
                List list = CollectionsKt.listOf((Object)string8);
                String string9 = it.imgUrl;
                if (string9 == null) {
                    string9 = "";
                }
                if ((string = it.imgUrl) == null) {
                    string = "";
                }
                Image image = new Image(string9, string);
                String string10 = it.detailProductLink;
                if (string10 == null) {
                    string10 = "";
                }
                String string11 = null;
                String string12 = string10;
                Image image2 = image;
                Product.Online online = new Product.Online(productId, string6, price2, list, string11, image2, string12);
                int n = it.quantity;
                double d3 = it.price;
                String string13 = it.currency;
                if (string13 == null) {
                    string13 = "";
                }
                Price price3 = new Price(d3, string13);
                String string14 = it.orderState;
                if (string14 == null) {
                    string14 = "";
                }
                List list2 = CollectionsKt.listOf((Object)new OrderItem(orderItemId, (Object)online, n, price3, string14));
                Date date = it.orderDate;
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"it.orderDate");
                long l = date.getTime();
                String string15 = it.detailOrderLink;
                if (string15 == null) {
                    string15 = "";
                }
                bl3 = false;
                long l2 = System.currentTimeMillis();
                String string16 = string15;
                onlineDto2 = new OnlineDto(orderId, string4, commerceId2, price, list2, l, bl3, string16, l2);
            }
            catch (Exception e) {
                onlineDto2 = null;
            }
            if (onlineDto2 == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            OnlineDto it$iv$iv = onlineDto;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List onlineItems = (List)destination$iv$iv;
        this.scrapService.saveOnlineOrders(onlineItems);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public CommerceManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        String apiKey = "";
        String layer = "";
        apiKey = "Nrcoz4wo1Z8mvEuyZzcFt3QUu3cCKpjC4TtijITZ";
        layer = "prod";
        this.scrapService = new ScrapBuilder().with(this.context).apiKey(apiKey).layer(layer).hour(0).logger(true).build();
    }
}

