/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.shared.util;

import android.text.TextUtils;
import com.tenqube.visual_scraper.shared.error.ParameterError;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\r\u001a\u00020\u000e\"\u00020\nJ'\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0010\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0016\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\nJ\u0010\u0010\u0017\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0018\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0015\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001c\u0010\u001a\u001a\u00020\b\"\u0004\b\u0000\u0010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\u000e\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/tenqube/visual_scraper/shared/util/Validator;", "", "()V", "fullDF", "Ljava/text/SimpleDateFormat;", "timeDf", "ymdDF", "gt", "", "value", "", "target", "in", "rules", "", "", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "isDate", "at", "isStr", "len", "isStrWithNull", "isTime", "isYMD", "lt", "notEmpty", "T", "values", "", "notNull", "object", "notZero", "app_release"})
public final class Validator {
    private static final SimpleDateFormat timeDf;
    private static final SimpleDateFormat ymdDF;
    private static final SimpleDateFormat fullDF;
    public static final Validator INSTANCE;

    public final void isDate(@Nullable String at) throws ParameterError {
        CharSequence charSequence = at;
        boolean bl = false;
        boolean bl2 = false;
        boolean isValid = !(charSequence == null || charSequence.length() == 0) && at.length() == 19;
        fullDF.setLenient(false);
        try {
            fullDF.parse(at);
        }
        catch (Exception e) {
            isValid = false;
        }
        if (!isValid) {
            throw (Throwable)new ParameterError("Check date :" + at);
        }
    }

    public final void isTime(@Nullable String at) throws ParameterError {
        CharSequence charSequence = at;
        boolean bl = false;
        boolean bl2 = false;
        boolean isValid = !(charSequence == null || charSequence.length() == 0) && at.length() == 8;
        timeDf.setLenient(false);
        try {
            timeDf.parse(at);
        }
        catch (Exception e) {
            isValid = false;
        }
        if (!isValid) {
            throw (Throwable)new ParameterError("Check date :" + at);
        }
    }

    public final void isYMD(@Nullable String at) throws ParameterError {
        CharSequence charSequence = at;
        boolean bl = false;
        boolean bl2 = false;
        boolean isValid = !(charSequence == null || charSequence.length() == 0) && at.length() == 10;
        ymdDF.setLenient(false);
        try {
            ymdDF.parse(at);
        }
        catch (Exception e) {
            isValid = false;
        }
        if (!isValid) {
            throw (Throwable)new ParameterError("Check date :" + at);
        }
    }

    public final void len(@Nullable String value, int len) throws ParameterError {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0 || value.length() != len) {
            throw (Throwable)new ParameterError(value + " is invalid value, (valid len : " + len + ')');
        }
    }

    public final void isStr(@NotNull String value, int len) throws ParameterError {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0 || value.length() > len) {
            throw (Throwable)new ParameterError(value + " is invalid value");
        }
    }

    public final void isStr(@NotNull String value) throws ParameterError {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new ParameterError(value + " is invalid value");
        }
    }

    public final void isStrWithNull(@Nullable String value, int len) throws ParameterError {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0 || value.length() > len) {
            throw (Throwable)new ParameterError(value + " is invalid value");
        }
    }

    public final void isStrWithNull(@Nullable String value) throws ParameterError {
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new ParameterError(value + " is empty");
        }
    }

    public final void gt(int value, int target) throws ParameterError {
        if (value < target) {
            throw (Throwable)new ParameterError("value: " + value + "/target:" + target);
        }
    }

    public final void lt(int value, int target) throws ParameterError {
        if (value > target) {
            throw (Throwable)new ParameterError("value: " + value + "/target:" + target);
        }
    }

    public final void in(@NotNull String value, String ... rules) throws ParameterError {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        boolean isValid = false;
        if (!TextUtils.isEmpty((CharSequence)value)) {
            for (String rule : rules) {
                if (!Intrinsics.areEqual((Object)value, (Object)rule)) continue;
                isValid = true;
                break;
            }
        }
        if (!isValid) {
            throw (Throwable)new ParameterError("value: " + value + " / value in (" + TextUtils.join((CharSequence)",", (Object[])rules) + "");
        }
    }

    public final void in(int value, int ... rules) throws ParameterError {
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        boolean isValid = false;
        for (int rule : rules) {
            if (value != rule) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw (Throwable)new ParameterError("value: " + value + "/ value in (" + TextUtils.join((CharSequence)",", (Iterable)ArraysKt.asList((int[])rules)) + "");
        }
    }

    public final void notZero(int value) throws ParameterError {
        if (value == 0) {
            throw (Throwable)new ParameterError("value: " + value + " value is zero");
        }
    }

    public final void notNull(@Nullable Object object) throws ParameterError {
        if (object == null) {
            throw (Throwable)new ParameterError("value is null");
        }
    }

    public final <T> void notEmpty(@Nullable List<? extends T> values) throws ParameterError {
        Collection collection = values;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            throw (Throwable)new ParameterError("values is empty");
        }
    }

    private Validator() {
    }

    static {
        Validator validator;
        INSTANCE = validator = new Validator();
        timeDf = new SimpleDateFormat("HH:mm:ss", Locale.KOREA);
        ymdDF = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA);
        fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
    }
}

