/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db.entity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.tenqube.visual_scraper.db.converter.OrderRuleConverter;
import com.tenqube.visual_scraper.db.converter.QueryRuleConverter;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import java.io.Serializable;

@Entity(tableName="order_web_rule", indices={@Index(value={"mall_id"}, unique=true)}, foreignKeys={@ForeignKey(entity=MallEntity.class, parentColumns={"m_id"}, childColumns={"mall_id"})})
@TypeConverters(value={OrderRuleConverter.class, QueryRuleConverter.class})
public class OrderWebRule
implements Serializable {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="_id")
    private int id;
    @ColumnInfo(name="mall_id")
    private final int mallId;
    @ColumnInfo(name="url")
    private final QueryRuleBody url;
    @ColumnInfo(name="request_body")
    private final String requestBody;
    @ColumnInfo(name="request_method")
    private final int requestMethod;
    @Nullable
    @ColumnInfo(name="period_scripts")
    private final QueryRuleBody periodScripts;
    @ColumnInfo(name="container")
    private final ParsingOrderRules container;
    @ColumnInfo(name="title")
    private final ParsingOrderRules title;
    @ColumnInfo(name="order_date")
    private final ParsingOrderRules orderDate;
    @ColumnInfo(name="order_hms")
    private final ParsingOrderRules orderHms;
    @ColumnInfo(name="order_option")
    private final ParsingOrderRules orderOption;
    @ColumnInfo(name="quantity")
    private final ParsingOrderRules quantity;
    @ColumnInfo(name="price")
    private final ParsingOrderRules price;
    @ColumnInfo(name="order_num")
    private final ParsingOrderRules orderNum;
    @ColumnInfo(name="order_state")
    private final ParsingOrderRules orderState;
    @ColumnInfo(name="img_url")
    private final ParsingOrderRules imgUrl;
    @ColumnInfo(name="detail_order_link")
    private final ParsingOrderRules detailOrderLink;
    @ColumnInfo(name="detail_product_link")
    private final ParsingOrderRules detailProductLink;

    public OrderWebRule(int mallId, QueryRuleBody url, String requestBody, int requestMethod, QueryRuleBody periodScripts, ParsingOrderRules container, ParsingOrderRules title, ParsingOrderRules orderDate, ParsingOrderRules orderHms, ParsingOrderRules orderOption, ParsingOrderRules quantity, ParsingOrderRules price, ParsingOrderRules orderNum, ParsingOrderRules orderState, ParsingOrderRules imgUrl, ParsingOrderRules detailOrderLink, ParsingOrderRules detailProductLink) {
        this.mallId = mallId;
        this.url = url;
        this.requestBody = requestBody;
        this.requestMethod = requestMethod;
        this.periodScripts = periodScripts;
        this.container = container;
        this.title = title;
        this.orderDate = orderDate;
        this.orderHms = orderHms;
        this.orderOption = orderOption;
        this.quantity = quantity;
        this.price = price;
        this.orderNum = orderNum;
        this.orderState = orderState;
        this.imgUrl = imgUrl;
        this.detailOrderLink = detailOrderLink;
        this.detailProductLink = detailProductLink;
    }

    public int getMallId() {
        return this.mallId;
    }

    public int getId() {
        return this.id;
    }

    public QueryRuleBody getUrl() {
        return this.url;
    }

    @NonNull
    public ParsingOrderRules getContainer() {
        return this.container;
    }

    @NonNull
    public ParsingOrderRules getTitle() {
        return this.title;
    }

    @NonNull
    public ParsingOrderRules getOrderDate() {
        return this.orderDate;
    }

    @NonNull
    public ParsingOrderRules getOrderHms() {
        return this.orderHms;
    }

    @NonNull
    public ParsingOrderRules getOrderOption() {
        return this.orderOption;
    }

    @NonNull
    public ParsingOrderRules getQuantity() {
        return this.quantity;
    }

    @NonNull
    public ParsingOrderRules getPrice() {
        return this.price;
    }

    @NonNull
    public ParsingOrderRules getOrderNum() {
        return this.orderNum;
    }

    @NonNull
    public ParsingOrderRules getOrderState() {
        return this.orderState;
    }

    @NonNull
    public ParsingOrderRules getImgUrl() {
        return this.imgUrl;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public QueryRuleBody getPeriodScripts() {
        return this.periodScripts;
    }

    public ParsingOrderRules getDetailOrderLink() {
        return this.detailOrderLink;
    }

    public ParsingOrderRules getDetailProductLink() {
        return this.detailProductLink;
    }

    public String toString() {
        return "OrderWebRuleJson{id=" + this.id + ", mallId=" + this.mallId + ", url='" + this.url + '\'' + ", requestBody='" + this.requestBody + '\'' + ", requestMethod=" + this.requestMethod + ", periodScripts='" + this.periodScripts + '\'' + ", container='" + this.container + '\'' + ", title='" + this.title + '\'' + ", orderDate='" + this.orderDate + '\'' + ", orderHms='" + this.orderHms + '\'' + ", orderOption='" + this.orderOption + '\'' + ", quantity='" + this.quantity + '\'' + ", price='" + this.price + '\'' + ", orderNum='" + this.orderNum + '\'' + ", orderState='" + this.orderState + '\'' + ", imgUrl='" + this.imgUrl + '\'' + ", detailOrderLink='" + this.detailOrderLink + '\'' + ", detailProductLink='" + this.detailProductLink + '\'' + '}';
    }
}

