package com.tenqube.visual_scraper.db.converter;

import androidx.room.TypeConverter;

import com.tenqube.visual_scraper.Injection;
import com.tenqube.visual_scraper.db.ScraperDatabase;
import com.tenqube.visual_scraper.model.query.Password;


public class AESConverter {

    @TypeConverter
    public static String encrypt(Password pwd) {
        return pwd == null ? null : Injection.provideAES256Cipher(ScraperDatabase.context).encrypt(pwd.getValue());
    }

    @TypeConverter
    public static Password decrypt(String pwd) {
        return pwd == null ? null : new Password(Injection.provideAES256Cipher(ScraperDatabase.context).decrypt(pwd));
    }

}
