/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.db;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
import androidx.room.TypeConverters;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import com.tenqube.visual_scraper.db.converter.Converters;
import com.tenqube.visual_scraper.db.dao.LoginApiRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginRuleDao;
import com.tenqube.visual_scraper.db.dao.LoginWebRuleDao;
import com.tenqube.visual_scraper.db.dao.MallDao;
import com.tenqube.visual_scraper.db.dao.MallWithUserDao;
import com.tenqube.visual_scraper.db.dao.OrderApiRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderDao;
import com.tenqube.visual_scraper.db.dao.OrderDetailWebRuleDao;
import com.tenqube.visual_scraper.db.dao.OrderWebRuleDao;
import com.tenqube.visual_scraper.db.dao.UserDao;
import com.tenqube.visual_scraper.db.dao.UserWithOrdersDao;
import com.tenqube.visual_scraper.db.entity.LoginApiRule;
import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.db.entity.MallEntity;
import com.tenqube.visual_scraper.db.entity.OrderApiRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.utils.AppExecutors;

@Database(entities={UserEntity.class, OrderEntity.class, MallEntity.class, LoginApiRule.class, LoginWebRule.class, OrderApiRuleJson.class, OrderWebRule.class, OrderDetailWebRuleJson.class}, version=2, exportSchema=false)
@TypeConverters(value={Converters.class})
public abstract class ScraperDatabase
extends RoomDatabase {
    public static Context context;
    public static final String DATABASE_NAME = "online_malls";
    private static ScraperDatabase sInstance;
    public static final Migration MIGRATION_1_2;
    private final MutableLiveData<Boolean> mIsDatabaseCreated = new MutableLiveData();

    public abstract UserDao userDao();

    public abstract OrderDao orderDao();

    public abstract UserWithOrdersDao userWithOrdersDao();

    public abstract MallWithUserDao mallWithUserDao();

    public abstract MallDao mallDao();

    public abstract LoginRuleDao loginRuleDao();

    public abstract LoginWebRuleDao loginWebRuleDao();

    public abstract LoginApiRuleDao loginApiRuleDao();

    public abstract OrderApiRuleDao orderApiRuleDao();

    public abstract OrderWebRuleDao orderWebRuleDao();

    public abstract OrderDetailWebRuleDao orderDetailWebRuleDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScraperDatabase getInstance(Context context, AppExecutors executors) {
        if (sInstance != null) return sInstance;
        Class<ScraperDatabase> clazz = ScraperDatabase.class;
        synchronized (ScraperDatabase.class) {
            if (sInstance != null) return sInstance;
            sInstance = ScraperDatabase.buildDatabase(context.getApplicationContext(), executors);
            sInstance.updateDatabaseCreated(context.getApplicationContext());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private static ScraperDatabase buildDatabase(final Context appContext, final AppExecutors executors) {
        context = appContext;
        return (ScraperDatabase)Room.databaseBuilder((Context)appContext, ScraperDatabase.class, (String)DATABASE_NAME).addCallback(new RoomDatabase.Callback(){

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                super.onCreate(db);
                executors.diskIO().execute(() -> {
                    ScraperDatabase database = ScraperDatabase.getInstance(appContext, executors);
                    database.setDatabaseCreated();
                });
            }
        }).addMigrations(new Migration[]{MIGRATION_1_2}).build();
    }

    private void updateDatabaseCreated(Context context) {
        if (context.getDatabasePath(DATABASE_NAME).exists()) {
            this.setDatabaseCreated();
        }
    }

    private void setDatabaseCreated() {
        this.mIsDatabaseCreated.postValue((Object)true);
    }

    private static void addDelay() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public LiveData<Boolean> getDatabaseCreated() {
        return this.mIsDatabaseCreated;
    }

    static {
        MIGRATION_1_2 = new Migration(1, 2){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE `order_detail_web_rule` ADD COLUMN `scripts` TEXT");
            }
        };
    }
}

