package com.tenqube.visual_scraper.mall;


import androidx.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.Date;

public class Coupang extends Mall {

    private static final String URL = "https://my.coupang.com";

    public Coupang(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    public String getBaseUrl() {
        return "https://www.coupang.com/";
    }

    protected Document makeDocument(Document document) {

        return Jsoup.parse(document.html().replace(" ,=\"\"", ""));

    }

    @Override
    protected String titleFilter(@NonNull String title) {
        return super.titleFilter(title);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate, Constants.DateFormatType.SLASH);
    }


    //https://my.coupang.com/purchase/detail/28000033822143
    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        if(!TextUtils.isEmpty(orderNum)) {
            int index = orderNum.lastIndexOf("/");
            if (index != -1 && orderNum.length() > index) {
                return orderNum.substring(index+1);
            }
        }
        return "";
    }

    @Override
    protected String orderStateFilter(@NonNull String orderState) {

        return TextUtils.isEmpty(orderState) ? "": orderState.replaceAll("\\d+", "").replace("\n", "");
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        int result = 1;
        try {
            if(!TextUtils.isEmpty(quantity)) {
                String[] temps = quantity.split("/");
                if (temps.length > 1) {
                    result = Integer.parseInt(temps[1].replace("개","").trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        //'12,490원 / 1개'
        if(!TextUtils.isEmpty(price)) {
            String[] temps = price.split("/");

            if(temps.length >= 1) {
                return Double.parseDouble(temps[0].replace(",", "").replace("원", "").trim());
            }
        }
        return 0;
    }

    @Override
    protected boolean showWebViewOrNot(String url) {
        return !TextUtils.isEmpty(url) && url.contains("https://login.coupang.com/login/pincode/select?pincodeTicketString=");

    }

    @Override
    public String getLogoutUrl() {
        return "javascript:document.querySelector('#logout > a').click();";
    }
}
