package com.tenqube.visual_scraper.market

import android.content.Context
import com.tenqube.visual_scraper.webviewhtmlloader.WebViewLoader

object MarketFactory {

    fun createScrapper(key: MarketKey, webViewHtmlLoader: WebViewLoader, context: Context): Market? {
        return when(key) {
            MarketKey.MarketKurly -> MarketKurly(webViewHtmlLoader, key, context)
            MarketKey.Gmarket -> Gmarket(webViewHtmlLoader, key, context)
            else -> SSG(webViewHtmlLoader, key, context)
        }
    }
}