package com.tenqube.visual_scraper.db.entity;

import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Index;
import androidx.room.PrimaryKey;

import java.io.Serializable;

@Entity(tableName = "login_api_rules",
        indices = {@Index(value = {"login_m_id"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "login_m_id")})
public class LoginApiRule implements Serializable {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    private int id;

    @ColumnInfo(name = "login_m_id")
    private final int mallId;

    @ColumnInfo(name = "url")
    private final String url;

    // 0: get / 1: post
    @ColumnInfo(name = "method_type")
    private final String methodType;

    @ColumnInfo(name = "request_body")
    private final String requestBody;

    @ColumnInfo(name = "token_key")
    private final String tokenKey;

//    @Ignore
//    @Nullable
//    private Map<String, String> loginParams;

    public LoginApiRule(int mallId, String url, String methodType, String requestBody/*,, @NonNull Map<String String> loginParams*/, String tokenKey) {
        this.mallId = mallId;
        this.url = url;
        this.methodType = methodType;
        this.requestBody = requestBody;
//        this.loginParams = loginParams;
        this.tokenKey = tokenKey;
    }


    public int getMallId() {
        return mallId;
    }

    public int getId() {
        return id;
    }

    public String getUrl() {
        return url;
    }

    public String getMethodType() {
        return methodType;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public String getTokenKey() {
        return tokenKey;
    }


    public void setId(int id) {
        this.id = id;
    }


    @Override
    public String toString() {
        return "LoginApiRule{" +
                "id=" + id +
                ", mallId='" + mallId + '\'' +
                ", url='" + url + '\'' +
                ", methodType='" + methodType + '\'' +
                ", requestBody='" + requestBody + '\'' +
                ", tokenKey='" + tokenKey + '\'' +
                '}';
    }
}
