/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.util.Date;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import timber.log.Timber;

public class Naver
extends Mall {
    public Naver(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        return DateUtils.transformDate(orderDate.split(" ")[1].trim(), Constants.DateFormatType.DOT);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        int index;
        if (!TextUtils.isEmpty((CharSequence)orderNum) && (index = orderNum.lastIndexOf("/")) != -1 && orderNum.length() > index) {
            return orderNum.substring(index + 1);
        }
        return "";
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replace("\uc0c1\ud488\uae08\uc561", "").replace(",", "").replace("\uc6d0", ""));
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        int index = imgUrl.lastIndexOf("?type");
        return index != -1 ? imgUrl.substring(0, index) : imgUrl;
    }

    @Override
    protected boolean doCheckLoginOTPForMall() {
        return true;
    }

    @Override
    protected boolean checkLoginFormId(Document document) {
        Elements elements = document.select("#login_form");
        Timber.i((String)("checkLoginFormId size : " + elements.size() + "/#login_form "), (Object[])new Object[0]);
        return elements.size() == 0;
    }
}

