package com.tenqube.visual_scraper.mall;


import androidx.annotation.NonNull;

import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;

import timber.log.Timber;

public class Auction extends Mall {

    public Auction(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum.replace("주문번호", "").trim();
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        StringBuilder result = new StringBuilder(imgUrl);
        int pos = result.lastIndexOf(".jpg");
        if (pos != -1) {
            result.setCharAt(pos-1, '5');
        }
        Timber.i("imgUrlFilter"+"result : "+ result.toString());
        return result.toString();
    }
}
