package com.tenqube.visual_scraper.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.tenqube.visual_scraper.db.entity.OrderWebRule;

import java.util.List;

@Dao
public interface OrderWebRuleDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(OrderWebRule orderWebRuleJson);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertList(List<OrderWebRule> orderWebRuleJsons);

    @Query("SELECT * FROM order_web_rule " +
            "WHERE mall_id = :mId")
    OrderWebRule getInfo(int mId);
}
