package com.tenqube.visual_scraper.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import timber.log.Timber;

public class Wemake extends Mall {

    String URL = "http://www.wemakeprice.com";

    public Wemake(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected List<OrderHtml> getOrderHtmls(Elements elements, OrderWebRule orderWebRule) {
        List<OrderHtml> orderHtmls = new ArrayList<>();

        OrderHtml beforeHtml = null;
        try {
            for (Element e : elements){

                OrderHtml currentHtml = parseHtml(e, beforeHtml);
                orderHtmls.add(currentHtml);

                beforeHtml = currentHtml;
            }

        } catch (Exception e){
            e.printStackTrace();
        }

        return orderHtmls;
    }

    private OrderHtml parseHtml(Element element, OrderHtml beforeHtml) {

        OrderHtml order = new OrderHtml();
        order.title = parseValue(element, orderWebRule.getTitle());
        order.orderDate = parseValue(element, orderWebRule.getOrderDate());
        order.orderHms = parseValue(element,orderWebRule.getOrderHms());
        order.orderOption = parseValue(element, orderWebRule.getOrderOption());
        order.quantity = parseValue(element, orderWebRule.getQuantity());
        order.price = parseValue(element, orderWebRule.getPrice());
        order.orderNum = parseValue(element, orderWebRule.getOrderNum());
        order.orderState = parseValue(element, orderWebRule.getOrderState());
        order.imgUrl = parseValue(element, orderWebRule.getImgUrl());
        order.detailOrderLink = parseValue(element, orderWebRule.getDetailOrderLink());
        order.detailProdLink = parseValue(element, orderWebRule.getDetailProductLink());


        if (beforeHtml != null && TextUtils.isEmpty(order.orderNum)){
            order.orderDate = beforeHtml.orderDate;
            order.orderNum = beforeHtml.orderNum;
            order.detailOrderLink = beforeHtml.detailOrderLink;
            order.orderState = beforeHtml.orderState;
        }
//        Timber.i("parseHtml"+"order : "+order);

        if (TextUtils.isEmpty(order.title) /*|| TextUtils.isEmpty(order.orderDate)*/
                /*|| TextUtils.isEmpty(order.price)*/ || TextUtils.isEmpty(order.orderNum)) return null;
        return order;


    }


    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty(orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10) : "";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected String orderOptionFilter(@NonNull String orderOption) {
        return orderOption
                .replace("\t", "")
                .replace("\n", "");
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        try {
            if (!TextUtils.isEmpty(orderNum) && orderNum.length() > 1) {
                return orderNum.substring(orderNum.indexOf("(") + 1, orderNum.indexOf(")"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            if (!TextUtils.isEmpty(quantity)) {

                String[] quantityStrArray = quantity.split("/");

                if(quantityStrArray.length > 1) {
                    return Integer.parseInt(quantityStrArray[1]
                            .replace("]", "")
                            .replace("개", "")
                            .trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}
