package com.tenqube.visual_scraper.model.api.response;

import com.tenqube.visual_scraper.db.entity.OrderDetailWebRuleJson;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

import java.io.Serializable;

public class OrderDetailHtmlResponse implements Serializable {

    private int mallId;

    private String url;

    private String requestBody;

    private String scripts;


    public int getMallId() {
        return mallId;
    }

    public String getUrl() {
        return url == null? "": url;
    }

    public String getRequestBody() {
        return requestBody == null? "": requestBody;
    }

    public String getScripts() {
        return scripts == null? "": scripts;
    }

    public OrderDetailWebRuleJson toEntity() {

        return new OrderDetailWebRuleJson(getMallId(),
                Utils.parseJsonObject(getUrl(), QueryRuleBody.class),
                Utils.parseJsonObject(getRequestBody(), QueryRuleBody.class),
                Utils.parseJsonObject(getScripts(), QueryRuleBody.class));


    }

}

