/*
 * Copyright 2017, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import com.tenqube.visual_scraper.db.entity.UserEntity;

import java.util.List;


@Dao
public interface UserDao {

    @Query("DELETE FROM users")
    void deleteAll();

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    Long insert(UserEntity user);

    @Update
    void update(UserEntity user);

    @Query( "SELECT * " +
            "FROM users ")
    List<UserEntity> getUsers();

    @Query( "SELECT * " +
            "FROM users where u_id = :uId ")
    UserEntity getUser(int uId);

    @Query( "SELECT * " +
            "FROM users where user_id = :name AND mall_id = :mId ")
    UserEntity getUserByNameAndMal(String name, int mId);

    @Query( "SELECT * " +
            "FROM users " +
            "WHERE is_login = :login")
    List<UserEntity> findUsersByLoginState(int login);

    @Query("UPDATE users SET last_scrap_at = :lastScrapAt WHERE mall_id = :mallId AND user_id = :userId")
    void updateUserLastScrapAt(long lastScrapAt, int mallId, String userId);

    @Query("UPDATE users SET is_login = :isLogin WHERE mall_id = :mallId")
    long updateUserIsLogin(int mallId, boolean isLogin);

    @Query( "DELETE  " +
            "FROM users WHERE mall_id = :mallId")
    void deleteUsersByMallId(int mallId);

//    @Query( "SELECT * " +
//            "FROM users WHERE uid  = :uid and userPwd = :pwd and mallName = :mall")
//    UserEntity getUser(String uid, String pwd, String mall);
//
//
//    @Query( "SELECT * " +
//            "FROM users WHERE mallName = :mall")
//    UserEntity getUser(String mall);
//
//
//
//    @Query( "DELETE  " +
//            "FROM users WHERE mallName = :mall")
//    void deleteUser(String mall);


}
