package com.tenqube.visual_scraper;

import android.content.Context;
import android.webkit.WebView;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.UserEntity;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.model.view.OrderInfo;
import com.tenqube.visual_scraper.model.view.ViewMoreInfo;

import java.util.List;

public interface ScrapService {

    public interface DataInteraction {

        String getUid();

        String getServiceAppName();

        void getAdId(Callback<String> callback);
    }

    void initialize();

    void destroy();

    WebView getWebView();

//    /**
//     * 사용자 등록
//     * - 사용자 등록 및 요청 url 정보 수신
//     * @param uuid
//     * @throws ParameterException
//     */
//    void register(String uuid) throws ParameterException;


    void startLoginAndParsing(String userId,
                              String userPwd,
                              int mId,
                              MallViewHandler mallViewService,
                              OnResultCallback<Integer> onResult) throws ParameterException;

    /**
     * 몰파싱
     * - 스크래핑 시작하기 로그인 정보 포함
     * @param userId 사용자 아이디
     * @param userPwd 사용자 패스워드
     * @param mId 온라인 몰 종류
     * @param onResult 몰 파싱 여부
     */
//    void startParsingMalls(String userId, String userPwd, int mId, OnResult onResult);

    /**
     * 로그인 활성화 된 몰 파싱
     * - 스크래핑 시작하기 이미 로그인정보 존재하는 경우
     */
    void startParsingMalls();


    /**
     * SDK 작동 설정
     * - SDK 사용 여부 설정
     * @param enabled
     */
    void setEnabled(boolean enabled);

    /**
     * 몰정보 조회
     * - 파싱된 몰 정보 가져오기 (User isLogin 정보와 함께)
     * @param callback
     */
    void getMallWithUsers(Callback<List<MallWithUser>> callback);


//    /**
//     * 주문 내역 조회
//     * - malls == null : 전체
//     * @param callback
//     * @param mIds mall_ids
//     */
//    void getOrders(Callback<List<OrderEntity>> callback, int... mIds);
//
    /**
     * 내역 단건 삭제
     * - 주문 id에 맞는 주문 삭제
     * @param orderId
     */
    void deleteOrder(int orderId);

    void hideOrder(int orderId);

    void deleteOrdersByOrderIds(int... orderIds);

//    /**
//     * 몰 정보에 따른 내역 삭제
//     * - malls == null 전체 모든 파싱 내역 초기화
//     * @param mIds
//     */
    void deleteAllOrders();


    void deleteOrderByMallIds(int... mIds);

    void insertUserEntity(UserEntity userEntity);

    void setParsingFrequency(int frequency);

    void getLastOrderId(ScrapService.Callback<Integer> callback);

//
//    /**
//     * 내역 csv 추출
//     * - malls == null 전체 추출
//     * @param callback
//     * @param mIds
//     */
//    void exportCSV(Callback<File> callback, int... mIds);
//
//    /**
//     * 내역 편집
//     * @param order
//     */
//    void updateOrder(OrderEntity order);
//
    /**
     * 로그아웃
     * - 해당 몰에 활성화 중인 계정, isActive false 처리하기
     * @param mId
     */
    void signOut(int mId, OnResultCallback<Void> callback);


    /**
     *  스크랩핑된 제품 리스트 받기
     */
    void getOrderList(int limit, ViewMoreInfo viewMoreInfo, OnResultCallback<List<OrderInfo>> callback);

//    /**
//     * 특정 몰에 따른 제품 정보 받기
//     * @param malls
//     */
//    void getProducts(Callback<List<OrderEntity>> callback, Constants.MALL... malls);
//
//    /**
//     * 전체 상품 목록 CSV로 추출
//     */
//    void exportCSV();

    interface Callback<T> {
        void onDataLoaded(T items);
    }

    interface onResultInterface<T> {
        void onDataLoaded(T item);

        void onFail();
    }

    interface OnResultCallback<T> {
        void onDataLoaded(T item);

        void onFail(int mId, Constants.ERROR error, String msg);
    }

    interface OnResult<T> {

        void onSuccess(int mId, T items, String msg);

        void onFail(int mId, Constants.ERROR error, String msg);

    }

    interface OnResultForMall {

        void onLoginSuccess(int mId, String msg);

        void onLoginFail(int mId, Constants.ERROR error, String msg);

    }
}
