package com.tenqube.visual_scraper.third_party.mart;

import android.content.Context;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistManager;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistScrapResult;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistSvrType;
import com.ksp.mobilesdkjava.MarketSystem.BOE.Receipt;
import com.ksp.mobilesdkjava.MarketSystem.BOE.ReceiptProduct;
import com.ksp.mobilesdkjava.MarketSystem.Base.e_MarketKeyCode;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.utils.AppExecutors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class MartScrapperImpl implements MartScrapper {

    private Context context;
    private static MartScrapper mInstance = null;
    private AppExecutors appExecutors = new AppExecutors();
    private boolean isInit = false;
    SDKAssistManager mgr = null;
    public static MartScrapper getInstance(Context ctx) {

        synchronized (MartScrapperImpl.class) {
            if (mInstance == null) {
                mInstance = new MartScrapperImpl(ctx);
            }
        }
        return mInstance;
    }

    private MartScrapperImpl(Context context) {
        this.context = context;

    }

    @Override
    public void init(ScrapService.Callback<String> callback) {

        if(isInit) {
            callback.onDataLoaded("");
        } else {

            appExecutors.diskIO().execute(() -> {
                String msg = "";
                mgr = new SDKAssistManager();
                File root_file = context.getFilesDir();
                String sdk_path = root_file.getAbsolutePath();
                try {
                    mgr.Init("visual", "7FCE8730-E363-401D-96C6-D6EFA9FB5D57", sdk_path, context, SDKAssistSvrType.e_SvrType.AZURE  );
                    isInit = true;
                } catch (Exception e) {
                    msg = e.toString();
                } finally {
                    String finalMsg = msg;
                    appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
                }

            });
        }

    }

//    @Override
//    public void getMarts(ScrapService.Callback<List<Mall>> callback) {
//
//        appExecutors.diskIO().execute(() -> {
//            List<Mall> results = new ArrayList<>();
//            try {
//                ArrayList<e_MarketKeyCode> martList = SDKAssist.GetAvailableMart();
//
//                for (e_MarketKeyCode mktCode : martList) {
//                    results.add(getMall(mktCode));
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
//            }
//        });
//
//    }

    @Override
    public void addUser(int mallId, String id, String password, ScrapService.Callback<String> callback) {

        appExecutors.diskIO().execute(() -> {

            String msg = "";
            try {
                e_MarketKeyCode keyCode = getMarketKeyCode(mallId);
                mgr.DeleteBuyer(keyCode, id);
                SDKAssistResult ret1 = mgr.AddBuyer(keyCode, id, password, true);
            } catch (Exception e) {
                msg = e.toString();
            } finally {
                String finalMsg = msg;
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
        });
    }

    @Override
    public void start(int mallId, ScrapService.Callback<String> callback) {

        appExecutors.networkIO().execute(() -> {
            String msg = "";
            try {
                SDKAssistScrapResult ret = mgr.ScrapReceipts();
            } catch (Exception e) {
                msg = e.toString();
            } finally {
                String finalMsg = msg;
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
        });
    }

    @Override
    public void getMartItems(int mallId, ScrapService.Callback<List<MartData>> callback) {

        appExecutors.diskIO().execute(() -> {

            List<MartData> results = new ArrayList<>();

            try {
                ArrayList<Receipt> receiptList = mgr.GetScrapedReceiptList();

                if(receiptList != null) {
                    Timber.i("ScrapManager" + receiptList.size());
                    for(Receipt rr: receiptList) {

                        Timber.i("ScrapManager mallId " + mallId);
                        Timber.i("ScrapManager getMallId(rr.MartEnumKeyCode) " + getMallId(rr.MartEnumKeyCode));

                        if(mallId == getMallId(rr.MartEnumKeyCode)) {
                            ArrayList<ReceiptProduct> productArrayList = mgr.GetReceiptProductListByKey(rr.ReceiptKey);

                            Timber.i("ScrapManager productArrayList " + productArrayList.size());

                            for (ReceiptProduct rp : productArrayList) {

                                Timber.i("ScrapManager BuyDate " + rp.BuyDate);
                                Timber.i("ScrapManager InsertDate " + rp.InsertDate);

                                MartData martData = new MartData();
                                martData.barcode = rp.Barcode;
                                martData.buyCount = rp.BuyCount;
                                // 2019-09-02 13:15:00
                                martData.buyDate = rp.BuyDate;
                                martData.insertDate = rp.InsertDate;
                                martData.name = rp.ProductName;
                                martData.price = rp.UnitPrice.doubleValue();
                                martData.receiptKey = rp.ReceiptKey;
                                martData.receiptProductKey = rp.ReceiptProductKey;
                                martData.orderAmount = rp.OrderAmount.toBigInteger().intValue();
                                results.add(martData);
                            }
                        }
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
            }
        });

    }

    private int getMallId(e_MarketKeyCode martKey) {
        if(martKey == e_MarketKeyCode.LotteMCoupon) {
            return Constants.MALL.LotteMart.getMallId();
        } else if(martKey == e_MarketKeyCode.EMartApp ) {
            return Constants.MALL.Emart.getMallId();

        }
        return -1;
    }

    private e_MarketKeyCode getMarketKeyCode(int mallId) {
        if(mallId == Constants.MALL.Emart.getMallId()) {
            return e_MarketKeyCode.EMartApp;
        } else {
            return e_MarketKeyCode.LotteMCoupon;
        }
    }


//    private MallEntity getMall(e_MarketKeyCode mktCode) {
//
//        if(mktCode == e_MarketKeyCode.EMartApp) {
//            return new MallEntity("emart", mktCode.name().hashCode(), "https://stimg.emart.com/store/images/new/common/gnb01.png",
//                    "https://stimg.emart.com/store/images/new/common/gnb01.png", false, false, R.drawable.img_eleven_street, "", "");
//
//        } else {
//            return new Mall("롯데M쿠폰", mktCode.name().hashCode(), "https://stimg.emart.com/store/images/new/common/gnb01.png",
//                    "https://stimg.emart.com/store/images/new/common/gnb01.png", false, false, R.drawable.img_eleven_street, "", "");
//
//        }
//    }

}
