package com.tenqube.visual_scraper.model.api.response;

import com.tenqube.visual_scraper.db.entity.LoginWebRule;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

import java.io.Serializable;

public class LoginWebRuleResponse implements Serializable {

    private int mallId;

    private String url;

    private String loginScripts;

    private String captchaContainer;

    private String failMessage;

    public int getMallId() {
        return mallId;
    }

    public String getUrl() {
        return url == null ? "" : url;
    }

    public String getLoginScripts() {
        return loginScripts == null ? "" : loginScripts;
    }

    public String getCaptchaContainer() {
        return captchaContainer == null ? "" : captchaContainer;
    }

    public String getFailMessage() {
        return failMessage == null ? "" : failMessage;
    }

    public LoginWebRule toEntity() {

        LoginWebRule values = new LoginWebRule(getMallId(),
                Utils.parseJsonObject(getUrl(), QueryRuleBody.class),
                Utils.parseJsonObject(getLoginScripts(), QueryRuleBody.class),
                Utils.parseJsonObject(getCaptchaContainer(), ParsingOrderRules.class),
                Utils.parseJsonObject(getFailMessage(), ParsingOrderRules.class));

        return values;



    }

}

