package com.tenqube.visual_scraper.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;

public class Hmall extends Mall {

    public Hmall(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected String orderOptionFilter(@NonNull String orderOption) {
        try {
            if (!TextUtils.isEmpty(orderOption)) {
                return orderOption.split("ㅣ")[0]
                        .replace("[", "")
                        .replace("]", "").trim();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return orderOption;
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            if (!TextUtils.isEmpty(quantity)) {

                String[] quantityStrArray = quantity.split("ㅣ");

                if(quantityStrArray.length > 1) {
                    return Integer.parseInt(quantityStrArray[1]
                            .replace("]", "")
                            .replace("개", "")
                            .trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}
