package com.tenqube.visual_scraper.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

import java.util.Date;

import timber.log.Timber;

public class Naver extends Mall {

    public Naver(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderDate(), 0, "href");
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
//        order.detailProdLink = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//
//        return order;
//    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {

        return DateUtils.transformDate(orderDate.split(" ")[1].trim(), Constants.DateFormatType.DOT);
    }

    //https://order.pay.naver.com/orderStatus/2018111365115961
    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        if(!TextUtils.isEmpty(orderNum)) {
            int index = orderNum.lastIndexOf("/");
            if (index != -1 && orderNum.length() > index) {
                return orderNum.substring(index+1);
            }
        }
        return "";
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replace("상품금액","").replace(",","").replace("원",""));
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        int index = imgUrl.lastIndexOf("?type");
        return index != -1 ? imgUrl.substring(0, index) : imgUrl;
    }

    @Override
    protected boolean doCheckLoginOTPForMall() {
        return true;
    }

    /**
     * login form 이 없으면 OTP page
     */
    @Override
    protected boolean checkLoginFormId(Document document) {
        Elements elements = document.select("#login_form");
        Timber.i("checkLoginFormId size : " + elements.size() + "/#login_form ");
        return elements.size() == 0;
    }
}
