package com.tenqube.visual_scraper.third_party.mart;

import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.utils.DateUtils;

public class MartData {

    public String barcode;

    /**
     *  2019-09-02 13:15:00
     */
    public int buyCount;
    public String buyDate;
    public int orderAmount;
    public Double price;
    public String name;
    public String receiptKey;
    public String receiptProductKey;

    /**
     *  2019-09-02 13:15:00
     */
    public String insertDate;


    public OrderEntity toEntity(int mId, int uId) {
        OrderEntity orderEntity = new OrderEntity();

        orderEntity.mId = mId;
        orderEntity.uId = uId;
        orderEntity.title = name;
        orderEntity.orderDate = DateUtils.parseYMdhms(buyDate);
        orderEntity.orderHms =  orderEntity.orderDate;
        orderEntity.orderOption = "";
        orderEntity.quantity = buyCount;
        orderEntity.price = price;
        orderEntity.currency = "KRW";

        orderEntity.orderNum = barcode;
        orderEntity.orderState = "";
        orderEntity.imgUrl = "";
        orderEntity.memo = "";
        orderEntity.isDelete = false;
        orderEntity.isSuccess = false;
        orderEntity.detailOrderLink = "";
        orderEntity.detailProductLink = "";
        return orderEntity;
    }
}


