package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;
import android.database.Cursor;

import com.tenqube.visual_scraper.db.entity.LoginWebRule;

import java.util.List;

@Dao
public interface LoginWebRuleDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertList(List<LoginWebRule> loginWebRule);

    @Query( "SELECT * " +
            "FROM login_web_rules ")
    List<LoginWebRule> findAll();

    @Query( "SELECT * " +
            "FROM login_web_rules WHERE mall_id = :mId ")
    LoginWebRule findById(int mId);

    @Query("SELECT * FROM login_web_rules ")
    public Cursor findList();



}
