package com.tenqube.visual_scraper.mall;

import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;


public class FactoryMall {

    public static Mall create(@NonNull MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {

        Constants.MALL mall = Constants.MALL.valueOf(mallData.getKeyName());
        switch (mall) {

            case Auction:
                return new Auction(mallData, repository, webViewManager);

            case Coupang:
                return new Coupang(mallData, repository, webViewManager);

            case ElevenStreet:
                return new ElevenStreet(mallData, repository, webViewManager);

            case Gmarket:
                return new Gmarket(mallData, repository, webViewManager);

            case Gshome:
                return new Gshome(mallData, repository, webViewManager);

            case Hmall:
                return new Hmall(mallData, repository, webViewManager);

            case Interpark:
                return new Interpark(mallData, repository, webViewManager);

            case LotteHome:
                return new LotteHome(mallData, repository, webViewManager);

            case NaverPay:
                return new Naver(mallData, repository, webViewManager);

            case Tmon:
                return new Tmon(mallData, repository, webViewManager);

            case Wemake:
                return new Wemake(mallData, repository, webViewManager);

            case Amazon:
                return new Amazon(mallData, repository, webViewManager);
        }


        return null;

    }


}
