package com.tenqube.visual_scraper.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

import java.util.Date;

import timber.log.Timber;

public class LotteHome extends Mall {

    public LotteHome(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderNum(), 0, null);
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
//        order.detailProdLink = parseValue(element, orderWebRule.getOrderDate(), 0, "onclick");
//
//        return order;
//    }


    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        return TextUtils.isEmpty(orderNum) ? orderNum : orderNum.replaceAll("-","");
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty(orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10): "";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            if (!TextUtils.isEmpty(quantity)) {

                String[] quantityStrArray = quantity.split("/");

                if(quantityStrArray.length > 1) {
                    return Integer.parseInt(quantityStrArray[1]
                            .replace("개", "")
                            .trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        // 로그인 페이지
        if (url.contains("https://secure.lotteimall.com/member/goLogin.lotte") || url.contains("https://secure.lotteimall.com/member/login/forward.LCLoginMem.lotte")
                || url.contains("https://members.lpoint.com/exView/manage/fdPassword") || url.contains("login") ) { //http://www.lotteimall.com/member/login
            return true;
        }
//        else if(url.contains("http://www.lotteimall.com/main/viewMain.lotte?dpml_no=1")) { // 쓰면안됨 비번오류 5번 락 풀은 후 돌아오는 페이지임
//            return false;
//        }
        return false;
    }

    @Override
    protected boolean checkCaptchaClass(Document document) {
        Elements elements = document.select(loginWebRule.getCaptchaContainer().selector);
        if (elements.size() == 0) elements = document.select("#catpcha_view_area");
        Timber.i("checkCaptchaClass" + "size : "+elements.size() + "/container : "+loginWebRule.getCaptchaContainer());
        return elements.size() != 0;
    }

    @Override
    protected boolean passFinishedWebPages(String url) {
        return !TextUtils.isEmpty(url) && (url.contains("http://www.lotteimall.com/member/forward.LCSSOGate.lotte?call_screen=pwfindfive") ||
                //http://www.lotteimall.com/?ccoDlyMsg=chlNo:0;ipAddr:10.144.136.95;mbrNo:201803198655;systemId:WEB
                url.contains("http://www.lotteimall.com/?ccoDlyMsg=chlNo") ||
                url.contains("http://www.lotteimall.com/member/login/forward.LCSSOLogin_proc.lotte"));
    }

    @Override
    protected boolean showWebViewOrNot(String url) {
        return !TextUtils.isEmpty(url) && url.contains("https://members.lpoint.com/exView/manage/fdPassword_01_001");
    }
}
