package com.tenqube.visual_scraper.third_party.mart;

import android.content.Context;

import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssist;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistResult;
import com.ksp.mobilesdkjava.MarketSystem.BOE.Receipt;
import com.ksp.mobilesdkjava.MarketSystem.BOE.ReceiptProduct;
import com.ksp.mobilesdkjava.MarketSystem.Base.e_MarketKeyCode;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.utils.AppExecutors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import timber.log.Timber;

public class MartScrapperImpl implements MartScrapper {

    private Context context;
    private static MartScrapper mInstance = null;
    private AppExecutors appExecutors = new AppExecutors();
    private boolean isInit = false;

    public static MartScrapper getInstance(Context ctx) {

        synchronized (MartScrapperImpl.class) {
            if (mInstance == null) {
                mInstance = new MartScrapperImpl(ctx);
            }
        }
        return mInstance;
    }

    private MartScrapperImpl(Context context) {
        this.context = context;
    }

    @Override
    public void init(ScrapService.Callback<String> callback) {

        if(isInit) {
            callback.onDataLoaded("");
        } else {
            File root_file = context.getFilesDir();
            String sdk_path = root_file.getAbsolutePath();

            appExecutors.diskIO().execute(() -> {

                String msg = "";
                try {
                    SDKAssist.InitWithGADID("DemoApp", "05D1EA32-A697-455D-8540-C42B00B97113", sdk_path, context );
                } catch (Exception e) {
                    msg = e.toString();
                } finally {
                    String finalMsg = msg;
                    appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
                }

            });
        }

    }

//    @Override
//    public void getMarts(ScrapService.Callback<List<Mall>> callback) {
//
//        appExecutors.diskIO().execute(() -> {
//            List<Mall> results = new ArrayList<>();
//            try {
//                ArrayList<e_MarketKeyCode> martList = SDKAssist.GetAvailableMart();
//
//                for (e_MarketKeyCode mktCode : martList) {
//                    results.add(getMall(mktCode));
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            } finally {
//                appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
//            }
//        });
//
//    }

    @Override
    public void addUser(String id, String password, ScrapService.Callback<String> callback) {

        appExecutors.diskIO().execute(() -> {

            String msg = "";
            try {
                SDKAssist.DeleteBuyer(e_MarketKeyCode.EMartApp, id);
                SDKAssistResult ret1 = SDKAssist.AddBuyer(e_MarketKeyCode.EMartApp, id, password);
            } catch (Exception e) {
                msg = e.toString();
            } finally {
                String finalMsg = msg;
                appExecutors.mainThread().execute(new Runnable() {
                    @Override
                    public void run() {

                        callback.onDataLoaded(finalMsg);
                    }
                });
            }
        });
    }

    @Override
    public void start(ScrapService.Callback<String> callback) {

        appExecutors.networkIO().execute(() -> {
            String msg = "";
            try {
                SDKAssistResult ret = SDKAssist.ScrapReceipts();
            } catch (Exception e) {
                msg = e.toString();
            } finally {
                String finalMsg = msg;
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalMsg));
            }
        });

    }

    @Override
    public void getMartItems(int mallId, ScrapService.Callback<List<MartData>> callback) {

        appExecutors.diskIO().execute(() -> {

            List<MartData> results = new ArrayList<>();

            try {
                ArrayList<Receipt> receiptList = SDKAssist.GetScrapedReceiptList();

                Timber.i("ScrapManager" + receiptList.size());
                for(Receipt rr: receiptList) {

                    Timber.i("ScrapManager mallId " + mallId);
                    Timber.i("ScrapManager getMallId(rr.MartEnumKeyCode) " + getMallId(rr.MartEnumKeyCode));

                    if(mallId == getMallId(rr.MartEnumKeyCode)) {
                        ArrayList<ReceiptProduct> productArrayList = SDKAssist.GetReceiptProductListByKey(rr.ReceiptKey);

                        Timber.i("ScrapManager productArrayList " + productArrayList.size());

                        for (ReceiptProduct rp : productArrayList) {

                            Timber.i("ScrapManager BuyDate " + rp.BuyDate);
                            Timber.i("ScrapManager InsertDate " + rp.InsertDate);

                            MartData martData = new MartData();
                            martData.barcode = rp.Barcode;
                            martData.buyCount = rp.BuyCount;
                            // 2019-09-02 13:15:00
                            martData.buyDate = rp.BuyDate;
                            martData.insertDate = rp.InsertDate;
                            martData.name = rp.ProductName;
                            martData.price = rp.UnitPrice.doubleValue();
                            martData.receiptKey = rp.ReceiptKey;
                            martData.receiptProductKey = rp.ReceiptProductKey;
                            martData.orderAmount = rp.OrderAmount.toBigInteger().intValue();
                            results.add(martData);
                        }
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
            }
        });

    }

    private int getMallId(e_MarketKeyCode martKey) {
        if(martKey == e_MarketKeyCode.LotteMCoupon) {
            return Constants.MALL.LotteMart.ordinal() + 1;
        } else if(martKey == e_MarketKeyCode.EMartApp ) {
            return Constants.MALL.Emart.ordinal() + 1;

        }
        return -1;
    }


//    private MallEntity getMall(e_MarketKeyCode mktCode) {
//
//        if(mktCode == e_MarketKeyCode.EMartApp) {
//            return new MallEntity("emart", mktCode.name().hashCode(), "https://stimg.emart.com/store/images/new/common/gnb01.png",
//                    "https://stimg.emart.com/store/images/new/common/gnb01.png", false, false, R.drawable.img_eleven_street, "", "");
//
//        } else {
//            return new Mall("롯데M쿠폰", mktCode.name().hashCode(), "https://stimg.emart.com/store/images/new/common/gnb01.png",
//                    "https://stimg.emart.com/store/images/new/common/gnb01.png", false, false, R.drawable.img_eleven_street, "", "");
//
//        }
//    }

}
