/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.third_party.mart;

import android.content.Context;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssist;
import com.ksp.mobilesdkjava.MSDKSystem.SDKAssistSystem.SDKAssistResult;
import com.ksp.mobilesdkjava.MarketSystem.BOE.Receipt;
import com.ksp.mobilesdkjava.MarketSystem.BOE.ReceiptProduct;
import com.ksp.mobilesdkjava.MarketSystem.Base.e_MarketKeyCode;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.third_party.mart.MartData;
import com.tenqube.visual_scraper.third_party.mart.MartScrapper;
import com.tenqube.visual_scraper.utils.AppExecutors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class MartScrapperImpl
implements MartScrapper {
    private Context context;
    private static MartScrapper mInstance = null;
    private AppExecutors appExecutors = new AppExecutors();
    private boolean isInit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MartScrapper getInstance(Context ctx) {
        Class<MartScrapperImpl> clazz = MartScrapperImpl.class;
        synchronized (MartScrapperImpl.class) {
            if (mInstance == null) {
                mInstance = new MartScrapperImpl(ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private MartScrapperImpl(Context context) {
        this.context = context;
    }

    @Override
    public void init(ScrapService.Callback<Boolean> callback) {
        if (this.isInit) {
            callback.onDataLoaded(true);
        } else {
            File root_file = this.context.getFilesDir();
            String sdk_path = root_file.getAbsolutePath();
            this.appExecutors.diskIO().execute(() -> {
                boolean isSuc = false;
                try {
                    SDKAssist.InitWithGADID((String)"DemoApp", (String)"05D1EA32-A697-455D-8540-C42B00B97113", (String)sdk_path, (Context)this.context);
                    isSuc = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.isInit = isSuc;
                    this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(this.isInit));
                }
            });
        }
    }

    @Override
    public void addUser(String id, String password, ScrapService.Callback<Boolean> callback) {
        this.appExecutors.diskIO().execute(() -> {
            boolean isSuc = false;
            try {
                SDKAssist.DeleteBuyer((e_MarketKeyCode)e_MarketKeyCode.EMartApp, (String)id);
                SDKAssistResult ret1 = SDKAssist.AddBuyer((e_MarketKeyCode)e_MarketKeyCode.EMartApp, (String)id, (String)password);
                isSuc = ret1.Success;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                callback.onDataLoaded(isSuc);
            }
        });
    }

    @Override
    public void start(ScrapService.Callback<Boolean> callback) {
        this.appExecutors.networkIO().execute(() -> {
            boolean isSuc = false;
            try {
                SDKAssistResult ret = SDKAssist.ScrapReceipts();
                isSuc = ret.Success;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                boolean finalIsSuc = isSuc;
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(finalIsSuc));
            }
        });
    }

    @Override
    public void getMartItems(int mallId, ScrapService.Callback<List<MartData>> callback) {
        this.appExecutors.diskIO().execute(() -> {
            ArrayList<MartData> results = new ArrayList<MartData>();
            try {
                ArrayList receiptList = SDKAssist.GetScrapedReceiptList();
                Timber.i((String)("ScrapManager" + receiptList.size()), (Object[])new Object[0]);
                for (Receipt rr : receiptList) {
                    Timber.i((String)("ScrapManager mallId " + mallId), (Object[])new Object[0]);
                    Timber.i((String)("ScrapManager getMallId(rr.MartEnumKeyCode) " + this.getMallId(rr.MartEnumKeyCode)), (Object[])new Object[0]);
                    if (mallId != this.getMallId(rr.MartEnumKeyCode)) continue;
                    ArrayList productArrayList = SDKAssist.GetReceiptProductListByKey((String)rr.ReceiptKey);
                    Timber.i((String)("ScrapManager productArrayList " + productArrayList.size()), (Object[])new Object[0]);
                    for (ReceiptProduct rp : productArrayList) {
                        Timber.i((String)("ScrapManager BuyDate " + rp.BuyDate), (Object[])new Object[0]);
                        Timber.i((String)("ScrapManager InsertDate " + rp.InsertDate), (Object[])new Object[0]);
                        MartData martData = new MartData();
                        martData.barcode = rp.Barcode;
                        martData.buyCount = rp.BuyCount;
                        martData.buyDate = rp.BuyDate;
                        martData.insertDate = rp.InsertDate;
                        martData.name = rp.ProductName;
                        martData.price = rp.UnitPrice.doubleValue();
                        martData.receiptKey = rp.ReceiptKey;
                        martData.receiptProductKey = rp.ReceiptProductKey;
                        martData.orderAmount = rp.OrderAmount.toBigInteger().intValue();
                        results.add(martData);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.appExecutors.mainThread().execute(() -> callback.onDataLoaded(results));
            }
        });
    }

    private int getMallId(e_MarketKeyCode martKey) {
        if (martKey == e_MarketKeyCode.LotteMCoupon) {
            return Constants.MALL.LotteMart.ordinal() + 1;
        }
        if (martKey == e_MarketKeyCode.EMartApp) {
            return Constants.MALL.Emart.ordinal() + 1;
        }
        return -1;
    }
}

