package com.tenqube.visual_scraper.third_party.mart;

import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.utils.DateUtils;

public class MartData {

    public String barcode;

    /**
     *  2019-09-02 13:15:00
     */
    public int buyCount;
    public String buyDate;
    public int orderAmount;
    public Double price;
    public String name;
    public String receiptKey;
    public String receiptProductKey;

    /**
     *  2019-09-02 13:15:00
     */
    public String insertDate;

    public OrderEntity toEntity(int uId) {
        OrderEntity orderEntity = new OrderEntity();

        orderEntity.uId = uId;
        orderEntity.title = name;
        orderEntity.orderDate = DateUtils.parseYMdhms(buyDate);
        orderEntity.orderHms =  orderEntity.orderDate;
        orderEntity.orderOption = buyCount + "";
        orderEntity.quantity = orderAmount;
        orderEntity.price = price;
        orderEntity.orderNum = barcode;
        orderEntity.orderState = "";
        orderEntity.imgUrl = "";
        return orderEntity;
    }
}


