/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper.mall;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.WebView;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.utils.DateUtils;
import java.text.ParseException;
import java.util.Date;

public class Amazon
extends Mall {
    public Amazon(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        String result = "";
        int pos = orderNum.lastIndexOf("oid=");
        if (pos > -1 && orderNum.length() > pos) {
            result = orderNum.substring(pos + 4);
        }
        return result;
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        if (TextUtils.isEmpty((CharSequence)orderDate) || orderDate.contains("Arriving") || orderDate.contains("\ub3c4\ucc29") || orderDate.contains("Delivered") || orderDate.contains("\ubc30\uc1a1")) {
            return new Date();
        }
        orderDate = orderDate.replace("Ordered on", "").trim();
        try {
            return DateUtils.AMAZON_DATE_FORMAT.parse(orderDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return 0.0;
    }

    @Override
    protected String currencyFilter(@NonNull String price) {
        return "USD";
    }

    @Override
    protected boolean checkLoginPageOrNot(String url) {
        if (url.contains("www.amazon.com/ap/signin") || url.contains("https://www.amazon.com/?ref_=nav_signin&captcha_verified=1&") || url.contains("https://www.amazon.com/ap/cvf/request?arb=") || url.contains("https://www.amazon.com/ap/cvf/verify")) {
            return true;
        }
        if (url.contains("https://www.amazon.com/?ref_=nav_signin&")) {
            return false;
        }
        return false;
    }

    @Override
    protected void setUserAgentString(int action, WebView webView) {
        if (action == 2) {
            webView.getSettings().setUserAgentString(null);
        } else {
            webView.getSettings().setUserAgentString("Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36");
        }
    }

    @Override
    protected boolean showWebViewOrNot(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && (url.contains("https://www.amazon.com/ap/cvf/request?arb=") || url.contains("https://www.amazon.com/ap/cvf/verify"));
    }
}

