/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_scraper;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import com.tenqube.visual_scraper.ScrapService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.db.entity.OrderEntity;
import com.tenqube.visual_scraper.mall.FactoryMall;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.mall.data.MallData;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.query.MallWithUser;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import timber.log.Timber;

public class ScrapManager {
    private static ScrapManager sInstance;
    public static final String HANDLER_MSG_ERROR = "error";
    public static final String HANDLER_MSG = "msg";
    public static final String HANDLER_MSG_MALL_ID = "mallId";
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAXIMUM_POOL_SIZE = 4;
    private static final int KEEP_ALIVE_TIME = 10;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private BlockingQueue<Runnable> mParserWorkQueue;
    private ThreadPoolExecutor mParserThreadPool;
    private final ScrapRepository repository;
    private final Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScrapManager getInstance(ScrapRepository repository, Handler handler) {
        if (sInstance != null) return sInstance;
        Class<ScrapManager> clazz = ScrapManager.class;
        synchronized (ScrapManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ScrapManager(repository, handler);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    private ScrapManager(ScrapRepository repository, Handler handler) {
        this.repository = repository;
        this.handler = handler;
        this.mParserWorkQueue = new LinkedBlockingQueue<Runnable>();
        this.mParserThreadPool = new ThreadPoolExecutor(2, 4, 10L, KEEP_ALIVE_TIME_UNIT, this.mParserWorkQueue);
    }

    private void sendMsg(@Nullable Handler handler, Constants.ScrapState state, Constants.ERROR error, String msg, int mallId) {
        Thread.interrupted();
        if (handler != null) {
            Message message = new Message();
            message.what = state.ordinal();
            Bundle bundle = new Bundle();
            bundle.putInt(HANDLER_MSG_ERROR, error.ordinal());
            bundle.putString(HANDLER_MSG, msg);
            bundle.putInt(HANDLER_MSG_MALL_ID, mallId);
            message.setData(bundle);
            handler.sendMessage(message);
        }
    }

    void startScrap(MallWithUser mallWithUser, WebViewManager webViewManager, boolean shouldInsert) {
        this.mParserThreadPool.execute(() -> {
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Timber.i((String)("loginMallWithUser : " + mallWithUser), (Object[])new Object[0]);
                this.repository.getLoginRule(mallWithUser.mall.getId(), loginRule -> {
                    Timber.i((String)("loginloginRule : " + loginRule), (Object[])new Object[0]);
                    Mall m = FactoryMall.create(new MallData(mallWithUser.mall.getId(), mallWithUser.mall.getName(), mallWithUser.mall.getDisplayName()), this.repository, webViewManager);
                    Timber.i((String)("loginMall : " + m), (Object[])new Object[0]);
                    if (m == null) {
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.EMPTY_MALL, "empty factory mall", mallWithUser.mall.getId());
                        return;
                    }
                    webViewManager.setMall(m);
                    if (loginRule != null && loginRule.loginWebRule != null) {
                        Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc874\uc7ac, startWebViewLogin", (Object[])new Object[0]);
                        m.startWebViewLogin(loginRule.loginWebRule, mallWithUser.user, shouldInsert, new ScrapService.OnResult<List<OrderEntity>>(){

                            @Override
                            public void onSuccess(int mId, List<OrderEntity> items, String msg) {
                                ScrapManager.this.repository.callInsertOrderList();
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.SUCCESS, Constants.ERROR.NONE, "success", mId);
                            }

                            @Override
                            public void onFail(int mId, Constants.ERROR error, String msg) {
                                ScrapManager.this.sendMsg(ScrapManager.this.handler, Constants.ScrapState.FAIL, error, msg, mId);
                            }
                        });
                    } else {
                        Timber.i((String)"login\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c ", (Object[])new Object[0]);
                        this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NOT_FOUND_LOGIN_RULE, "\ub85c\uadf8\uc778 \ub8f0\uc815\ubcf4 \uc5c6\uc74c", mallWithUser.mall.getId());
                    }
                });
            }
            catch (Exception e) {
                this.sendMsg(this.handler, Constants.ScrapState.FAIL, Constants.ERROR.NOT_FOUND_LOGIN_RULE, e.toString(), mallWithUser.mall.getId());
            }
        });
    }

    static {
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    }
}

