package com.tenqube.visual_scraper.db.dao;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.tenqube.visual_scraper.db.entity.MallEntity;

import java.util.List;

@Dao
public interface MallDao {

    @Query("SELECT * " +
            "FROM malls " +
            "WHERE m_id = :mId " +
            "AND is_active = 1")
    MallEntity getMall(int mId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertList(List<MallEntity> mallEntity);

    @Query( "SELECT * " +
            "FROM malls " +
            "WHERE is_active = 1")
    List<MallEntity> getMalls();

    @Query( "SELECT * " +
            "FROM malls " +
            "WHERE m_id in (:ids)")
    List<MallEntity> findMallByIds(List<Integer> ids);

}
