package com.tenqube.visual_scraper;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;

import com.tenqube.visual_scraper.constants.Constants;

import timber.log.Timber;

public class Main2Activity extends AppCompatActivity implements MallViewHandler, ScrapService.OnResultCallback<Integer>  {

    public static final String API_KEY = "sVPnrNW0Fg4fujRSLJrYn8FJWyO5BtS21hAbOYXc";//"6jLdbwCdun2BzhbCq7yEhak9K80ZcJZWaS8aIKYw";
    private WebView webView;
    FrameLayout frameLayout;
    ScrapService scrapService;

    int i = 8;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main2);
        frameLayout = findViewById(R.id.container);
        Button button = findViewById(R.id.next_btn);
        Button startBtn = findViewById(R.id.start_btn);
        Button totalBtn = findViewById(R.id.total_btn);

        Button loginBtn = findViewById(R.id.login);

        EditText idInput = findViewById(R.id.id_input);
        EditText passwordInput = findViewById(R.id.password_input);

        try {

            scrapService = new ScrapServiceImpl(this, API_KEY, Constants.LAYER.DEV, new ScrapService.DataInteraction() {

                @Override
                public String getUid() {
                    return "testUUID";
                }

                @Override
                public String getServiceAppName() {
                    return "visual";
                }

                @Override
                public void getAdId(ScrapService.Callback<String> callback) {
                    callback.onDataLoaded("test_ad_id");
                }
            });

            button.setOnClickListener(view -> {
                if (i<12) {
                    i++;
                }else if(i == 12) {
                    i=1;
                }

                goParsing(i);
            });

            startBtn.setOnClickListener(view -> {

                goParsing(i);

            });

            totalBtn.setOnClickListener(view -> {

                scrapService.startParsingMalls();

            });

            loginBtn.setOnClickListener(view -> {
                try {
                    scrapService.startLoginAndParsing(idInput.getText().toString(), passwordInput.getText().toString(), i, this, new ScrapService.OnResultCallback<Integer>() {
                        @Override
                        public void onDataLoaded(Integer mallId) {
                            scrapService.signOut(i, null);
                            Timber.i("success: %d", mallId);
                        }

                        @Override
                        public void onFail(int mId, Constants.ERROR error, String msg) {
                            Timber.i("onFail: %d", mId);
                            Timber.i("error: %s", msg);
                        }
                    });

                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void goParsing(int mallId) {
        try {
            switch (mallId) {
                case 1 :
                    scrapService.startLoginAndParsing( "aa", "1", 1, this, this);
//                    scrapService.insertUserEntity(new UserEntity(1, "oyabungz", "tenqube1@"));
                    break;
                case 2 :
                    scrapService.startLoginAndParsing( "aa", "1", 2, this, this);
//                    scrapService.insertUserEntity(new UserEntity(2, "assayaroo2@naver.com", "tenqube1@"));
                    break;
                case 3 :
                    scrapService.startLoginAndParsing( "aa", "1", 3, this, this);
//                    scrapService.insertUserEntity(new UserEntity(3, "oyabongz", "tenqube1@"));
                    break;
                case 4 :
                    scrapService.startLoginAndParsing( "aa","1",4, this, this);
                    break;
                case 5 :
                    scrapService.startLoginAndParsing( "aa","1",5, this, this);
                    break;
                case 6 :
                    scrapService.startLoginAndParsing( "aa","1",6, this, this); //tilleul92 (비번변경-막힘)
                    break;
                case 7 :
                    scrapService.startLoginAndParsing("aa","1",7, this, this);
                    break;
                case 8 :
                    scrapService.startLoginAndParsing("aa","1",8, this, this);
                    break;
                case 9 :
                    scrapService.startLoginAndParsing("aa", "1", 9, this, null);
                    break;
                case 10 :
                    scrapService.startLoginAndParsing("aa","1",10, this, this);
                    break;
                case 11 :
                    scrapService.startLoginAndParsing("aa","1",11, this, this);
                    break;
                case 12 :
                    scrapService.startLoginAndParsing("aa","1",12, this, this);
//                    scrapService.startLoginAndParsing("cide@dreamwiz.com","tenqube10",12, this);

                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notifyInProgressStatus(String msg) {

    }


    @Override
    public void setWebView(WebView webView, int isVisible) {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (View.VISIBLE == isVisible) {
                frameLayout.removeView(scrapService.getWebView());
                frameLayout.addView(scrapService.getWebView());
            } else {
//                frameLayout.removeView(scrapService.getWebView());
            }
        });

    }

    @Override
    public void onDataLoaded(Integer mallId) {
        Timber.i("onFail: %d", mallId);
    }

    @Override
    public void onFail(int mId, Constants.ERROR error, String msg) {
        Timber.i("onFail: %d", mId);
        Timber.i("error: %s", msg);
    }

    @NonNull
    @Override
    public Context getContext() {
        return this;
    }
}
