package com.tenqube.visual_scraper.model.api.response;

import com.tenqube.visual_scraper.db.entity.OrderWebRule;
import com.tenqube.visual_scraper.model.jsonParsing.ParsingOrderRules;
import com.tenqube.visual_scraper.model.jsonParsing.QueryRuleBody;
import com.tenqube.visual_scraper.utils.Utils;

import java.io.Serializable;

public class OrderWebRuleResponse implements Serializable {

    private int mallId;

    private String url;

    private String requestBody;

    private int requestMethod;

    private String periodScripts;

    private String container;

    private String title;

    private String orderDate;

    private String orderHms;

    private String orderOption;

    private String quantity;

    private String price;

    private String orderNum;

    private String orderState;

    private String imgUrl;

    private String detailOrderLink;

    private String detailProductLink;

    public int getMallId() {
        return mallId;
    }

    public String getUrl() {
        return url == null ? "" : url;
    }

    public String getRequestBody() {
        return requestBody == null ? "" : requestBody;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    public String getPeriodScripts() {
        return periodScripts == null ? "" : periodScripts;
    }

    public String getContainer() {
        return container == null ? "" : container;
    }

    public String getTitle() {
        return title == null ? "" : title;
    }

    public String getOrderDate() {
        return orderDate == null ? "" : orderDate;
    }

    public String getOrderHms() {
        return orderHms == null ? "" : orderHms;
    }

    public String getOrderOption() {
        return orderOption == null ? "" : orderOption;
    }

    public String getQuantity() {
        return quantity == null ? "" : quantity;
    }

    public String getPrice() {
        return price == null ? "" : price;
    }

    public String getOrderNum() {
        return orderNum == null ? "" : orderNum;
    }

    public String getOrderState() {
        return orderState == null ? "" : orderState;
    }

    public String getImgUrl() {
        return imgUrl == null ? "" : imgUrl;
    }

    public String getDetailOrderLink() {
        return detailOrderLink == null ? "" : detailOrderLink;
    }

    public String getDetailProductLink() {
        return detailProductLink == null ? "" : detailProductLink;
    }

    public OrderWebRule toEntity() {

        return new OrderWebRule(
                getMallId(),
                Utils.parseJsonObject(getUrl(), QueryRuleBody.class),
                getRequestBody(),
                getRequestMethod(),
                Utils.parseJsonObject(getPeriodScripts(), QueryRuleBody.class),
                Utils.parseJsonObject(getContainer(), ParsingOrderRules.class),
                Utils.parseJsonObject(getTitle(), ParsingOrderRules.class),
                Utils.parseJsonObject(getOrderDate(), ParsingOrderRules.class),
                Utils.parseJsonObject(getOrderHms(), ParsingOrderRules.class),
                Utils.parseJsonObject(getOrderOption(), ParsingOrderRules.class),
                Utils.parseJsonObject(getQuantity(), ParsingOrderRules.class),
                Utils.parseJsonObject(getPrice(), ParsingOrderRules.class),
                Utils.parseJsonObject(getOrderNum(), ParsingOrderRules.class),
                Utils.parseJsonObject(getOrderState(), ParsingOrderRules.class),
                Utils.parseJsonObject(getImgUrl(), ParsingOrderRules.class),
                Utils.parseJsonObject(getDetailOrderLink(), ParsingOrderRules.class),
                Utils.parseJsonObject(getDetailProductLink(), ParsingOrderRules.class)

        );

    }

}

