package com.tenqube.visual_scraper.crawler;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.webkit.JavascriptInterface;

public class ScrapInterface {

    public static final String SHOW_HTML_JS = "javascript:window.HtmlViewer.showHTML" +
            "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');";

    public static final String CHECK_HTML_JS = "javascript:window.HtmlViewer.checkHTML" +
            "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');";


    @NonNull
    private OnScrapInteractionListener mListener;

    public interface OnScrapInteractionListener {
        void showHtml(String html);
    }

    public ScrapInterface(@NonNull OnScrapInteractionListener listener) {
        this.mListener = listener;
    }

    @SuppressLint("SetJavaScriptEnabled")
    @JavascriptInterface
    public void showHTML(String html) {
        mListener.showHtml(html);
    }


}
