package com.tenqube.visual_scraper.manager;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import com.tenqube.visual_scraper.MallViewService;
import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.mall.Mall;
import com.tenqube.visual_scraper.utils.Utils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.Timer;
import java.util.TimerTask;

import timber.log.Timber;

public class WebViewManager {

    private static final long TIMEOUT_TIMEMILLIS = 30000;

    private Mall mall;
    private WebView webView;
    private Context context;
    private Handler handler;
    private CookieManager cookieManager;

    private WebViewCallback callback;
    private Timer timer, tempTimer;
    private TimerTask timerTask;
    private String webUrl;
    private String scripts;
    private String tempScripts;
    private int action;

    public static final int DEFAULT = 0;
    public static final int LOGIN = 1;
    public static final int ORDER_PARSING = 2;
    private int failedCnt = 0;
    private boolean isFinishedCallback;
    @Nullable private MallViewService mallViewService;

    private boolean isVisibleWebView;
    private boolean isLoginFinished;
    private boolean isCheckedCaptcha;
    private boolean isClosedWebView;

    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled", "AddJavascriptInterface"})
    public WebViewManager(Context context, @Nullable MallViewService mallViewService) {
        this.context = context;
        this.handler = new Handler(Looper.getMainLooper());
        this.mallViewService = mallViewService;
        initWebView();
    }


    @SuppressLint({"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView() {

        this.webView = /*view == null ? */new WebView(context) /*: view*/;

//        createCookieManager();
        webView.clearCache(true);
        webView.clearHistory();
        Utils.clearCookies(context);

        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setUserAgentString(Constants.USER_AGENT_NORMAL);

        webView.addJavascriptInterface(new ScriptInterface(), "HtmlViewer");
        webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) webView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_COMPATIBILITY_MODE);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);

        webView.getSettings().setSupportZoom(true);
        webView.getSettings().setBuiltInZoomControls(true);
        webView.getSettings().setPluginState(WebSettings.PluginState.ON);

        webView.setLayerType(WebView.LAYER_TYPE_SOFTWARE, null);
        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Timber.i("onReceivedError" +"error : "+error);

                stopTimer();

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {

                    if (error != null) {

                        Timber.i("onReceivedError" + "error : "+error.getErrorCode());

                        switch (error.getErrorCode()) {
                            case ERROR_UNSUPPORTED_SCHEME:
                                return;
                            case ERROR_TOO_MANY_REQUESTS:
                                return;
                            case ERROR_UNKNOWN:
                                return;
//                            case ERROR_TIMEOUT:
//                                return;
                    }
                }}
                onFailReceivedError(error);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Timber.i("onPageFinished" +"url : "+url);

                onPageFinishedCallback(view, url);

            }

            @SuppressWarnings("deprecation")
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Timber.i("shouldOverrideUrlLoading [1] : %s",url);
                return checkUrlForShouldOverride(url);
            }

            @TargetApi(Build.VERSION_CODES.N)
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                final String url = request.getUrl().toString();
                Timber.i("shouldOverrideUrlLoading [2] : %s", url);
                return checkUrlForShouldOverride(url);

            }

        });

        webView.setWebChromeClient(new WebChromeClient(){
            @Override
            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                Timber.i("onJsAlert" +"message : "+ message + "url : "+url);
                stopTimer();

                if (!Constants.DEFAULT_MALL.LotteHome.equals(mall.mallData.getKeyName())) loginFailed(message);
                Toast.makeText(context, message, Toast.LENGTH_LONG).show();
                result.confirm();
                return true;
            }
        });

    }

    private boolean checkUrlForShouldOverride(String url) {
//        if (mall.shouldPopupView)
        if (Constants.DEFAULT_MALL.LotteHome.equals(mall.mallData.getKeyName())){

            if (url.contains("https://secure.lotteimall.com/member/login/forward.LCLoginFailProc.lotte")) {
                loginFailed("아이디와 비밀번호를 확인하고 다시 로그인 해주세요.");

            } else if(url.contains("http://www.lotteimall.com/?ccoDlyMsg=chlNo")) {
                loginFailed("다시 로그인해주세요.");
            }
        }
        return false;
    }

    private void onFailReceivedError(WebResourceError error) {
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                if (isClosedWebView) return;

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                    callback.onFail(error.getErrorCode(), error.getDescription().toString());
                } else {
                    callback.onFail(403, error.toString());
                }
            } catch (Exception e) {
                e.printStackTrace();
                callback.onFail(403, "error");
            }
        });
    }

    private void onPageFinishedCallback(WebView view, String url) {

        if (action == LOGIN && isLoginFinished) return;

        if("https://finish/".equals(url)) return;

        if ("about:blank".equals(url) && view.getTag() != null) {
            view.loadUrl(view.getTag().toString());
            return;
        } else {
            view.setTag(url);
        }

        // mall 별 pass 할 page
        if (mall.shouldPassFinishedWebPages(url)) return;

//      sycCookie();
        stopTimer();


        if(/*url.contains(webUrl) && */scripts != null){
            loadScripts(scripts);
            tempScripts = scripts;
            scripts = null;
            isFinishedCallback = true;
        } else if(action == LOGIN/* && scripts == null*/){

            if (url.contains(webUrl) || mall.identifyLoginPageOrNot(url) /*|| url.contains("https://nid.naver.com/signin/")*/){
                // 로그인 실패
                Timber.i("scripts fail"+"!! " + failedCnt + " "+ isVisibleWebView);
                // check Error or Captcha
//                if (failedCnt ==0) {
                if (isVisibleWebView) return;

                if (mall.shouldShowWebView(url)) {
                    Timber.i("shouldShowWebView true");
                    showWebView();
                    return;
                }

                if ( mall.doCheckLoginError() || (mall.doCheckLoginCaptcha() && !isVisibleWebView && !isCheckedCaptcha)){
                    getLoginHtml();
//                    failedCnt++;
                } else {
                    if (!isVisibleWebView) retryLogin();
                }


            } else {
                // 로그인 성공
                Timber.i("scripts success"+"!!isVisibleWebView : "+isVisibleWebView);
                failedCnt = 0;
                if (isVisibleWebView) {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        if (mallViewService != null) mallViewService.setWebView(webView, View.GONE);
                        isVisibleWebView = false;
                    });
                }
                finish();
            }
        } else {
            if (action == ORDER_PARSING &&  (url.contains("main") || url.contains("Home") || (url.contains("www.naver.com") ))) {
                Timber.i("page"+"Pass!!!!!!!");
//                        startTimer();
                return;
            }
            failedCnt = 0;
            finish();
        }
    }

    private void retryLogin() {
        failedCnt++;
        Timber.i("retryLogin" +"failedCnt : "+failedCnt);

        if (failedCnt == 4){
            new Handler(Looper.getMainLooper()).post(() -> {

                callback.onFail(400, mall.mallData.getDisplayName() + "조회 실패"); // 실패
                closeWebView();
            });
            return;
        }

        // mall amazon 이면 script 내용 바꾸기
        if (failedCnt == 2 && mall.mallData.getKeyName().equalsIgnoreCase(Constants.DEFAULT_MALL.Amazon)) {
            int pos = tempScripts.indexOf(";");
            if (tempScripts.length() > pos) tempScripts ="javascript:" + tempScripts.substring(pos+1,tempScripts.length());
            Timber.i("retryLogin" +"tempScripts : "+tempScripts +"pos: "+pos);
        }
        loadScripts(tempScripts);
    }

    private void finish() {
        Timber.i("webview" +"finish "+ action);
        if (callback != null) {
            switch (action) {
                case DEFAULT :
                    callback.onResult(webUrl, webView);
                    break;
                case LOGIN :
                    new Handler(Looper.getMainLooper()).post(() -> {

//                        if (checkLoginState()){
                            if (mallViewService != null)
                                mallViewService.notifyInProgressStatus(mall.mallData.getDisplayName()+" 쇼핑 내역을 불러오고 있습니다");
                            failedCnt = 0;
                            isLoginFinished = true;
                            callback.onResult(null, webView);//cookieManager.getCookie(webUrl), webView); // 성공
//                        } else {
//                            callback.onFail(403, "로그인 실패");
//                            closeWebView();
//                        }
                    });
                    break;

                case ORDER_PARSING :
                    // html 가져오기
                    getHtml();
//                    closeWebView();
                    break;
            }
        }
    }

    class ScriptInterface {

        ScriptInterface() {
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void showHTML(String html) {
//            Timber.i("showHTML", "html : "+html);
            if (callback != null) {
                callback.onResult(html, webView);

                if (mallViewService != null)
                    mallViewService.notifyInProgressStatus(mall.mallData.getDisplayName()+" 조회 완료");

                closeWebView();
            }
        }

        @SuppressLint("SetJavaScriptEnabled")
        @JavascriptInterface
        public void checkHTML(String html) {
//            Timber.i("checkHTML"+ " html : "+html);

            Document document = Jsoup.parse(html);
            if (document == null) return;

            if (mall.doCheckLoginError()) {
                String error = mall.checkLoginError(document);
                Timber.i("checkHTML" + "error : "+error);

                if (!TextUtils.isEmpty(error)) {
                    // 로그인 오류 > CLOSED
                    loginFailed(error);

                } else if (mall.doCheckLoginCaptcha()){
                    if (!findCapchaImage(document)) retryLogin();
                } else {
                    retryLogin();
                }
            } else if (mall.doCheckLoginCaptcha()){
                // 로그인 에러 안주는 몰일경우 retryLogin 대신 로그인 에러처리 (x) -> 몇번수행후 에러처리
                if (!findCapchaImage(document)) retryLogin();
            }
        }

    }

    private boolean findCapchaImage(Document document) {
        isCheckedCaptcha = true;
        if (mall.checkCaptchaImage(document)){
            // webView 띄우기
            Timber.i("checkHTML " +"captcha");
            showWebView();
            return true;
        }
        return false;
    }

    private void showWebView() {
        new Handler(Looper.getMainLooper()).post(() -> {
            if (mallViewService != null){
                isVisibleWebView = true;
                mallViewService.setWebView(webView, View.VISIBLE);
            } else {
                // 로그인 실패
                callback.onFail(403, "login fail");
                closeWebView();
            }
        });
    }

    @JavascriptInterface
    private void getHtml() {
        webView.loadUrl("javascript:window.HtmlViewer.showHTML" +
                "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
    }

    @JavascriptInterface
    private void getLoginHtml() {
        Timber.i("getLoginHtml" +"!!");

        handler.post(()-> {
            webView.loadUrl("javascript:window.HtmlViewer.checkHTML" +
                    "('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
        });
    }

    private void loginFailed(String error){
        new Handler(Looper.getMainLooper()).post(() -> {
            isLoginFinished = true;
            stopTimer();
//            Toast.makeText(context, ""+error, Toast.LENGTH_LONG).show();

            callback.onFail(400, error);

            if (isVisibleWebView) {
                if (mallViewService != null) mallViewService.setWebView(webView, View.GONE);
                isVisibleWebView = false;
            }
            closeWebView();


        });
    }

    public WebViewManager setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    public WebViewManager setScripts(String scripts) {
        this.scripts = scripts;
        return this;
    }

    public WebViewManager setAction(int mode) {
        this.action = mode;
        return this;
    }

    public void build(WebViewCallback callback) {
        this.callback = callback;
        if (webUrl != null){
            isLoginFinished = false;
            isClosedWebView = false;
            loadWebView(webUrl, false);
//            if (mallViewService != null)mallViewService.setWebView(webView,View.VISIBLE);
        } else {
            callback.onFail(403, "webUrl does not exist");
            closeWebView();
        }
    }

    public void setMall(Mall mall) {
        this.mall = mall;

        if (mall.mallData != null && Constants.DEFAULT_MALL.LotteHome.equals(mall.mallData.getKeyName())) webView.getSettings().setSupportMultipleWindows(true);
    }

    private void loadScripts(String scripts) {

        try {

            // 1. cookie 존재 유무 체크
//            if (checkLoginState()) {
//                // 1-1. cookie 존재 > Success
//                if (action == LOGIN){
//                    finish();
//                } else {
//                    // scripts 실행
//                    Timber.i("loadScripts","scripts 실행 "+ scripts);
//                    loadWebView(scripts);
//                    scripts = null;
//                }
//            } else {
                // 1-2. cookie 존재 x  > 로그인 스크립트 실행
//                callback.onFail(403, "로그인 되어있지 않음");
            Timber.i("loadScripts" +"scripts 실행 "+ scripts);
//            Toast.makeText(context, "loadScripts : "+scripts, Toast.LENGTH_SHORT).show();
            loadWebView(scripts, true);

            tempTimer = timer;
            Timber.i("TEST" +"temp : "+tempTimer + "//"+timer + "/"+timerTask);
            if (failedCnt > 2) return;
            int delayMillis = 10000;

            handler.postDelayed(() -> {
                    // 3초후에 finish 가 울리지 않는다면
                    // timer 체크
                    Timber.i("TESTT" +"temp : "+tempTimer + "//"+timer + "/"+timerTask);
                    if (action == LOGIN && timer != null) {
                        Timber.i("loadScripts" + "OnPageFinished 안울림 , 로그인 오류 체크 ");
                        // 로그인 오류 체크
                        stopTimer();
                        getLoginHtml();

                    }

                    if (action == ORDER_PARSING && timer != null && mall.doParsingMall()) {
                        stopTimer();
                        if (isFinishedCallback) {
                            finish();
                        }
                    }
                }, 6000);
//            }
        } catch (Exception e) {
            e.printStackTrace();
            callback.onFail(403, e.toString());
            closeWebView();
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void loadWebView(String urlOrScripts, boolean isScripts) {
        Timber.i("loadWebView" +"url :"+ urlOrScripts + " //\nisScript : "+ isScripts +"//" +scripts );
        startTimer();

        handler.postDelayed(() ->{
            mall.setWebviewSettings(action, webView);
            webView.loadUrl(urlOrScripts, null);
        }, /*isScripts? 1000 :*/ 500);
    }


    public interface WebViewCallback {
        void onResult(String item, WebView webView);
        void onFail(int statusCode, String statusMessage);
    }


    private void closeWebView() {
        Timber.i("closeWebView" +"!!");
        if (webView != null) {
            handler.post(() -> {
                if (action == LOGIN) isLoginFinished = true;
                failedCnt = 0;
                isFinishedCallback = false;
                isClosedWebView = true;


//                webView.stopLoading();
//                webView.clearCache(true);
//                webView.clearHistory();
//
//                if (cookieManager != null) {
//
//                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//                        cookieManager.removeSessionCookies(value -> {
//                        });
//                    } else {
//                        cookieManager.removeSessionCookie();
//                    }
//                    cookieManager.removeAllCookie();
//                }
            });
        }
    }

    private void stopTimer(){
        if(timer != null){
            timer.cancel();
            timer.purge();
            timer = null;
            timerTask = null;
        }
    }

    public WebView getWebView(){
        return webView;
    }

    private void startTimer() {

        timer = new Timer();
        timerTask = new TimerTask() {
            @Override
            public void run() {

                handler.post(() -> {
                    Timber.i("TimeOut" + "action : "+action + "/url : "+webUrl+" scripts : "+scripts);
                    stopTimer();
                    if (isFinishedCallback) {
                        finish();
                        return;
                    }

                    closeWebView();
                    callback.onFail(403, Constants.MESSAGES.TIMEOUT_FAIL);
                });

            }
        };
        timer.schedule(timerTask, TIMEOUT_TIMEMILLIS);

    }
}
