/*
 * Copyright 2016, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tenqube.visual_scraper.db.entity;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.Index;
import android.arch.persistence.room.PrimaryKey;
import android.arch.persistence.room.TypeConverters;
import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.db.converter.AESConverter;
import com.tenqube.visual_scraper.model.query.Password;

@Entity(tableName = "users",
        indices = {@Index(value = {"mall_id", "user_id", "pwd"}, unique = true)},
        foreignKeys =  {
                @ForeignKey(entity = MallEntity.class,
                        parentColumns = "m_id",
                        childColumns = "mall_id")})
public final class UserEntity {

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "u_id")
    private int id;

    @NonNull
    @ColumnInfo(name = "mall_id")
    private final int mallId;

    @NonNull
    @ColumnInfo(name = "user_id")
    private final String userId;

    @NonNull
    @TypeConverters({AESConverter.class})
    @ColumnInfo(name = "pwd")
    private final Password userPwd;

    @ColumnInfo(name = "cookie")
    private String cookie;

    @ColumnInfo(name = "is_login")
    private boolean isLogin;

    @ColumnInfo(name = "is_progress")
    private boolean isProgress;

    @ColumnInfo(name = "last_scrap_at")
    private long lastScrapAt; //마지막 스크랩한 날짜


    public UserEntity(@NonNull int mallId, @NonNull String userId, @NonNull Password userPwd) {
        this.mallId = mallId;
        this.userId = userId;
        this.userPwd = userPwd;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NonNull
    public int getMallId() {
        return mallId;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    @NonNull
    public Password getUserPwd() {
        return userPwd;
    }

    public String getCookie() {
        return cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public boolean isLogin() {
        return isLogin;
    }

    public void setLogin(boolean login) {
        isLogin = login;
    }

    public boolean isProgress() {
        return isProgress;
    }

    public void setProgress(boolean progress) {
        isProgress = progress;
    }

    public long getLastScrapAt() {
        return lastScrapAt;
    }

    public void setLastScrapAt(long lastScrapAt) {
        this.lastScrapAt = lastScrapAt;
    }

    @Override
    public String toString() {
        return "UserEntity{" +
                "id=" + id +
                ", mallId=" + mallId +
                ", userId='" + userId + '\'' +
                ", userPwd='" + userPwd + '\'' +
                ", cookie='" + cookie + '\'' +
                ", isLogin=" + isLogin +
                ", isProgress=" + isProgress +
                ", lastScrapAt=" + lastScrapAt +
                '}';
    }
}
