package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;

import java.util.Date;

public class Naver extends Mall {

    public Naver(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderDate(), 0, "href");
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
//        order.detailProdLink = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//
//        return order;
//    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {

        return DateUtils.transformDate(orderDate.split(" ")[1].trim(), Constants.DateFormatType.DOT);
    }

    @Override
    protected String orderNumFilter(@NonNull String orderNum) {
        return orderNum
                .replace("/orderStatus/", "")
                .replace("https://pay.naver.com/payments/detail/", "")
                .replace("https://pay.naver.com/payments", "");
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        return Double.parseDouble(price.replace("상품금액","").replace(",","").replace("원",""));
    }

    @Override
    protected String imgUrlFilter(@NonNull String imgUrl) {
        int index = imgUrl.lastIndexOf("?type");
        return index != -1 ? imgUrl.substring(0, index) : imgUrl;
    }
}
