package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.model.OrderHtml;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;

import java.util.Date;

public class LotteHome extends Mall {

    public LotteHome(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

//    @Override
//    protected OrderHtml parseHtml(@NonNull Element element) {
//        OrderHtml order = new OrderHtml();
//        order.title = parseValue(element, orderWebRule.getTitle(), 0, null); // 필수
//        order.orderDate = parseValue(element, orderWebRule.getOrderDate(), 0, null);
//        order.orderHms = parseValue(element, orderWebRule.getOrderHms(), 0, null);
//        order.orderOption = parseValue(element, orderWebRule.getOrderOption(), 0, null);
//        order.quantity = parseValue(element, orderWebRule.getQuantity(), 0, null);
//        order.price = parseValue(element, orderWebRule.getPrice(), 0, null);
//        order.orderNum = parseValue(element, orderWebRule.getOrderNum(), 0, null);
//        order.orderState = parseValue(element, orderWebRule.getOrderState(), 0, null);
//        order.imgUrl = parseValue(element, orderWebRule.getImgUrl(), 0, null);
//        order.detailProdLink = parseValue(element, orderWebRule.getOrderDate(), 0, "onclick");
//
//        return order;
//    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty(orderDate) && orderDate.length() > 9 ? orderDate.substring(0, 10): "";
        return DateUtils.transformDate(date, Constants.DateFormatType.DASH);
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            if (!TextUtils.isEmpty(quantity)) {

                String[] quantityStrArray = quantity.split("/");

                if(quantityStrArray.length > 1) {
                    return Integer.parseInt(quantityStrArray[1]
                            .replace("개", "")
                            .trim());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}
