package com.tenqube.visual_scraper.scrap.mall;


import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_scraper.constants.Constants;
import com.tenqube.visual_scraper.manager.WebViewManager;
import com.tenqube.visual_scraper.repository.ScrapRepository;
import com.tenqube.visual_scraper.scrap.mall.data.MallData;
import com.tenqube.visual_scraper.utils.DateUtils;

import org.jsoup.nodes.Element;

import java.util.Date;

public class Interpark extends Mall {

    public Interpark(MallData mallData, ScrapRepository repository, WebViewManager webViewManager) {
        super(mallData, repository, webViewManager);
    }

    @Override
    protected double priceFilter(@NonNull String price) throws NumberFormatException {
        try {
            return Double.parseDouble(price.split("\\(")[0]
                    .replace(",", "")
                    .replace("원", ""));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int quantityFilter(@NonNull String quantity) throws NumberFormatException {
        try {
            String[] str = quantity.split("\\(");
            if (str.length > 1) {
                return Integer.parseInt(str[1]
                        .replace(")", "")
                        .replace("개", ""));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected Date orderDateFilter(@NonNull String orderDate) {
        String date = !TextUtils.isEmpty(orderDate) && orderDate.length() > 7 ? orderDate.substring(0, 8): "";
        return DateUtils.transformDate(date, Constants.DateFormatType.NONE);
    }
}
